/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.xml.jstats;

import java.io.IOException;
import java.net.URL;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.jstats.distributions.Dist;
import nl.tudelft.simulation.jstats.distributions.DistBernoulli;
import nl.tudelft.simulation.jstats.distributions.DistBeta;
import nl.tudelft.simulation.jstats.distributions.DistBinomial;
import nl.tudelft.simulation.jstats.distributions.DistConstant;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.distributions.DistExponential;
import nl.tudelft.simulation.jstats.distributions.DistNormal;
import nl.tudelft.simulation.jstats.distributions.DistTriangular;
import nl.tudelft.simulation.jstats.streams.Java2Random;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.logger.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public final class DistributionParser {
    public static final URL DISTRIBUTIONFILE_SCHEMA = DistributionParser.class.getResource("/xsd/distribution.xsd");

    private DistributionParser() {
    }

    public static Dist parseDistribution(Element element, SimulatorInterface simulator) throws IOException {
        try {
            String streamId = element.getAttributeValue("stream");
            Java2Random stream = new Java2Random();
            try {
                stream = simulator.getReplication().getStream(streamId);
            }
            catch (Exception e) {
                Logger.warning(DistributionParser.class, (String)"parseDistribution", (String)("stream " + stream + " not found" + "\nDefault stream used instead."));
            }
            Namespace xsi = Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance");
            String distributionType = element.getAttributeValue("type", xsi);
            if (distributionType.startsWith("dsol:")) {
                distributionType = distributionType.substring(5);
            }
            if ("bernouilli".equals(distributionType)) {
                double p = new Double(element.getAttributeValue("p"));
                return new DistBernoulli((StreamInterface)stream, p);
            }
            if ("beta".equals(distributionType)) {
                double alpha1 = new Double(element.getAttributeValue("alpha1"));
                double alpha2 = new Double(element.getAttributeValue("alpha2"));
                return new DistBeta((StreamInterface)stream, alpha1, alpha2);
            }
            if ("binomial".equals(distributionType)) {
                long n = new Long(element.getAttributeValue("n"));
                double p = new Double(element.getAttributeValue("p"));
                return new DistBinomial((StreamInterface)stream, n, p);
            }
            if ("constant".equals(distributionType)) {
                double c = new Double(element.getAttributeValue("c"));
                return new DistConstant((StreamInterface)stream, c);
            }
            if ("exponential".equals(distributionType)) {
                double lambda = new Double(element.getAttributeValue("lambda"));
                return new DistExponential((StreamInterface)stream, lambda);
            }
            if ("normal".equals(distributionType)) {
                double mean = new Double(element.getAttributeValue("mean"));
                double stdev = new Double(element.getAttributeValue("stdev"));
                return new DistNormal((StreamInterface)stream, mean, stdev);
            }
            if ("triangular".equals(distributionType)) {
                double a = new Double(element.getAttributeValue("a"));
                double b = new Double(element.getAttributeValue("b"));
                double c = new Double(element.getAttributeValue("c"));
                return new DistTriangular((StreamInterface)stream, a, b, c);
            }
            throw new Exception("Unknown distribution in " + element.getName());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public static DistDiscrete parseDiscreteDistribution(Element element, SimulatorInterface simulator) throws IOException {
        return (DistDiscrete)DistributionParser.parseDistribution(element, simulator);
    }

    public static DistContinuous parseContinuousDistribution(Element element, SimulatorInterface simulator) throws IOException {
        return (DistContinuous)DistributionParser.parseDistribution(element, simulator);
    }
}

