/*
 * @(#)Event April 4, 2003
 * 
 * Copyright (c) 2003-2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event;

/**
 * The Event class forms the reference implementation for the EventInterface.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Apr 26, 2004
 * @since 1.4
 */
public class Event implements EventInterface
{

	/**
	 * type is the type of the event
	 * 
	 * @uml.property name="type"
	 */
	protected EventType type;

	/**
	 * content refers to the content of the event
	 * 
	 * @uml.property name="content"
	 */
	protected Object content;

	/**
	 * the source of an event
	 * 
	 * @uml.property name="source"
	 */
	protected Object source;


	/**
	 * constructs a new Event.
	 * 
	 * @param type the name of the Event.
	 * @param source the source of the sender.
	 * @param content the content of the event.
	 */
	public Event(final EventType type, final Object source, final Object content)
	{
		this.type = type;
		this.source = source;
		this.content = content;
	}

	/**
	 * @see nl.tudelft.simulation.event.EventInterface#getSource()
	 * 
	 * @uml.property name="source"
	 */
	public Object getSource()
	{
		return this.source;
	}

	/**
	 * @see nl.tudelft.simulation.event.EventInterface#getContent()
	 * 
	 * @uml.property name="content"
	 */
	public Object getContent()
	{
		return this.content;
	}

	/**
	 * @see nl.tudelft.simulation.event.EventInterface#getType()
	 * 
	 * @uml.property name="type"
	 */
	public EventType getType()
	{
		return this.type;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return "[" + this.getClass().getName() + ";" + this.getType() + ";"
				+ this.getSource() + ";" + this.getContent() + "]";
	}
}