/*
 * @(#) EventInterface.java Dec 10, 2003
 * 
 * Copyright (c) 2003-2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event;

import java.io.Serializable;

/**
 * The EventInterface defines the interface for all events in the event project.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.9 2004-03-18
 * @since 1.0
 */
public interface EventInterface extends Serializable
{
	/**
	 * returns the source of the event. The source is the sender of the event
	 * 
	 * @return the source of the event
	 */
	Object getSource();

	/**
	 * returns the content of this event.
	 * 
	 * @return the content of this event
	 */
	Object getContent();

	/**
	 * returns the type of the event.
	 * 
	 * @return the eventType of the event
	 */
	EventType getType();
}