/*
 * @(#) EventType.java Sep 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event;

import java.io.Serializable;

/**
 * The EventType is a masker used for the subscription to asynchronous events.
 * Eventtypes are used by EventProducers to show which events they potentially
 * fire. EventTypes should be defined as static final fields.
 * <p>
 * The EventType class is made final for a number of reasons. The most important
 * is to assure that the <code>equals</code> and <code>hashcode</code>
 * methods are not overloaded.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.08 2004-03-18
 * @since 1.0
 */
public final class EventType implements Serializable
{
	/** value is the flag number */
	private int value;

	/** name refers to the name of the eventType */
	private String name;

	/**
	 * constructs a new EventType.
	 * 
	 * @param name the name of this eventType. Two values are not appreciated :
	 *        <code>null</code> and <code>""</code>.
	 */
	public EventType(final String name)
	{
		super();
		if (name == null || name.equals(""))
		{
			throw new IllegalArgumentException("name == null || name == \"\"");
		}
		this.value = name.hashCode();
		this.name = name;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(final Object arg0)
	{
		if (!(arg0 instanceof EventType))
		{
			return false;
		}
		return this.value == ((EventType) arg0).value;
	}

	/**
	 * Returns a hash code for the name of the this eventType. The hash code for
	 * an <code>EventType</code> object is computed as <blockquote>
	 * 
	 * <pre>
	 * 
	 *   s[0]*31&circ;(n-1) + s[1]*31&circ;(n-2) + ... + s[n-1]
	 *  
	 * </pre>
	 * 
	 * </blockquote> using <code>int</code> arithmetic, where
	 * <code>s[i]</code> is the <i>i </i>th character of the name of the
	 * eventType, <code>n</code> is the length of the name, and <code>^</code>
	 * indicates exponentiation. This algoritm assures JVM, host, time
	 * independency.
	 * 
	 * @return a hash code value for this object.
	 */
	public int hashCode()
	{
		return this.value;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return this.name;
	}
}