/*
 * @(#)TimedEventInterface.java April 4, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event;

/**
 * The TimedEvent is the reference implementation for a timed event.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.7 2004-03-18
 * @since 1.0
 */
public class TimedEvent extends Event
{

	/**
	 * timeStamp refers to the time stamp of the event
	 * 
	 * @uml.property name="timeStamp"
	 */
	private double timeStamp = Double.NaN;


	/**
	 * constructs a new timed event.
	 * 
	 * @param type the eventType of the event.
	 * @param source the source of the event.
	 * @param value the value of the event.
	 * @param timeStamp the timeStamp.
	 */
	public TimedEvent(final EventType type, final Object source,
			final Object value, final double timeStamp)
	{
		super(type, source, value);
		this.timeStamp = timeStamp;
	}

	/**
	 * returns the timeStamp of this event.
	 * 
	 * @return the timestamp as double.
	 * 
	 * @uml.property name="timeStamp"
	 */
	public double getTimeStamp()
	{
		return this.timeStamp;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return super.toString().split("]")[0] + ";" + this.getTimeStamp() + "]";
	}
}