/*
 * @(#) Reference.java Dec 9, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event.ref;

import java.io.Serializable;

/**
 * A Reference interface defining the indirect pointer access to an object.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.2 2004-03-18
 * @see java.lang.ref.Reference
 * @since 1.2
 */
public interface Reference extends Serializable
{
	/**
	 * Returns this reference object's referent. If this reference object has
	 * been cleared, either by the program or by the garbage collector, then
	 * this method returns <code>null</code>.
	 * 
	 * @return The object to which this reference refers, or <code>null</code>
	 *         if this reference object has been cleared
	 */
	Object get();
}