/*
 * @(#) StrongReference.java Dec 9, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event.ref;

import java.io.Serializable;

/**
 * A StrongReference class represents a normal pointer relation to a reference.
 * This class is created to complete the java.lang.ref package. This class
 * ensures that references can be used without casting to either an object or a
 * reference. Strong references are not created to be cleaned by the garbage
 * collector. Since they represent normal pointer relations, they are the only
 * ones which might be serialized. This class therefore implements
 * <code>java.io.Serializable</code>
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.0, 2004-03-18
 * @since 1.0
 */
public class StrongReference implements Reference, Serializable
{
	/** the referent */
	private Object referent = null;

	/**
	 * Creates a new strong reference that refers to the given object. The new
	 * reference is not registered with any queue.
	 * 
	 * @param referent object the new strong reference will refer to
	 */
	public StrongReference(final Object referent)
	{
		this.referent = referent;
	}

	/**
	 * @see nl.tudelft.simulation.event.ref.Reference#get()
	 */
	public Object get()
	{
		return this.referent;
	}
}