/*
 * @(#) WeakReference.java Dec 9, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event.ref;

import java.io.IOException;
import java.io.ObjectOutputStream;

/**
 * A WeakReference. The weakreference extends the
 * <code>java.lang.ref.WeakReference</code> and besides implementing the
 * Reference interface no changes are defined.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.2 2004-03-18
 * @since 1.2
 */
public class WeakReference implements Reference
{
	/** the reference */
	private java.lang.ref.WeakReference reference = null;

	/**
	 * Creates a new weak reference that refers to the given object. The new
	 * reference is not registered with any queue.
	 * 
	 * @param referent object the new weak reference will refer to
	 */
	public WeakReference(final Object referent)
	{
		this.reference = new java.lang.ref.WeakReference(referent);
	}

	/**
	 * @see nl.tudelft.simulation.event.ref.Reference#get()
	 */
	public Object get()
	{
		return this.reference.get();
	}

	/**
	 * writes a serializable method to stream
	 * 
	 * @param out the outputstream
	 * @throws IOException on IOException
	 */
	private void writeObject(final ObjectOutputStream out) throws IOException
	{
		out.writeObject(this.reference.get());
	}

	/**
	 * reads a serializable method from stream
	 * 
	 * @param in the inputstream
	 * @throws IOException on IOException
	 */
	private void readObject(final java.io.ObjectInputStream in)
			throws IOException
	{
		try
		{
			this.reference = new java.lang.ref.WeakReference(in.readObject());
		} catch (Exception exception)
		{
			throw new IOException(exception.getMessage());
		}
	}
}