/*
 * RemoteEventListener.java Created @ Mar 24, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.event.remote;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;

import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;

/**
 * The RemoteEventListener class embodies a remoteEventListener. <br>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Mar 24, 2004 <br>
 * @author <a
 *         href="http://www.tbm.tudelft.nl/webstaf/stijnh/index.htm">Stijn-Pieter
 *         van Houten </a>
 */
public class RemoteEventListener implements RemoteEventListenerInterface
{
	/** the owner of the remote listener */
	private EventListenerInterface owner = null;

	/**
	 * Constructs a new RemoteListener.
	 * 
	 * @param owner The owner of the listener.
	 */
	public RemoteEventListener(final EventListenerInterface owner)
	{
		super();
		try
		{
			UnicastRemoteObject.exportObject(this);
		} catch (RemoteException remoteException)
		{
			Logger.getLogger("nl.tudelft.simulation.event").severe(
					remoteException.getMessage());
		}

		this.owner = owner;
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface#
	 *      notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event) throws RemoteException
	{
		this.owner.notify(event);
	}
}