/*
 * @(#)RemoteEventProducer.java Dec 4, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.event.remote;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;

import nl.tudelft.simulation.event.EventProducer;

/**
 * The RemoteEventProducer provides a remote implementation of the
 * eventProducer.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a>
 * <p>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty
 * 
 * @version 1.0 Dec 4, 2003
 * 
 * @author <a
 *         href="http://www.tbm.tudelft.nl/webstaf/stijnh/index.htm">Stijn-Pieter
 *         van Houten </a>
 */
public class RemoteEventProducer extends EventProducer implements
		RemoteEventProducerInterface
{
	/**
	 * Constructs a new RemoteEventProducer.
	 */
	public RemoteEventProducer()
	{
		super();
		try
		{
			UnicastRemoteObject.exportObject(this);
		} catch (RemoteException remoteException)
		{
			Logger.getLogger("nl.tudelft.simulation.event").severe(
					remoteException.getMessage());

		}
	}
}