/*
 * @(#) EventIterator.java Nov 19, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event.util;

import java.util.Iterator;

import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;

/**
 * The Event producing iterator provides a set to which one can subscribe
 * interest in entry changes.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.1, 2004-03-18
 * @since 1.2
 */
public class EventIterator extends EventProducer implements java.util.Iterator
{
	/** OBJECT_REMOVED_EVENT is fired on removel of entries */
	public static final EventType OBJECT_REMOVED_EVENT = new EventType(
			"OBJECT_REMOVED_EVENT");

	/** our parent iterator */
	private Iterator parent = null;

	/**
	 * constructs a new Iterator.
	 * 
	 * @param parent parent.
	 */
	public EventIterator(final Iterator parent)
	{
		super();
		this.parent = parent;
	}

	/**
	 * @see java.util.Iterator#hasNext()
	 */
	public boolean hasNext()
	{
		return this.parent.hasNext();
	}

	/**
	 * @see java.util.Iterator#next()
	 */
	public Object next()
	{
		return this.parent.next();
	}

	/**
	 * @see java.util.Iterator#remove()
	 */
	public void remove()
	{
		this.parent.remove();
		this.fireEvent(OBJECT_REMOVED_EVENT, null);
	}
}