/*
 * @(#) EventProducerChild.java Sep 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event;

import java.io.Serializable;

/**
 * The EventProducerChild is an event producer used in JUNIT tests.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.4, 2004-03-18
 * @since 1.2
 */
public class EventProducerChild extends EventProducer implements Serializable
{
	/** EVENT_A is merely a test event */
	public static final EventType EVENT_A = new EventType("EVENT_A");

	/** EVENT_B is merely a test event */
	public static final EventType EVENT_B = new EventType("EVENT_B");

	/** EVENT_C is merely a test event */
	public static final EventType EVENT_C = new EventType("EVENT_C");

	/**
	 * constructs a new EventProducerChild
	 */
	protected EventProducerChild()
	{
		super();
	}
}