/*
 * @(#) EventIteratorTest.java Sep 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.event.ref;

import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * The test script for the reference package. All classes in this package are
 * tested with this test
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.0, 2004-03-18
 * @since 1.2
 */
public class EventRefTest extends TestCase
{
	/** TEST_METHOD is the name of the test method */
	public static final String TEST_METHOD = "test";

	/**
	 * constructs a new EventIteratorTest.
	 */
	public EventRefTest()
	{
		this(TEST_METHOD);
	}

	/**
	 * constructs a new EventIteratorTest
	 * 
	 * @param method the name of the test method
	 */
	public EventRefTest(final String method)
	{
		super(method);
	}

	/**
	 * tests the classes in the reference class.
	 */
	public void test()
	{
		try
		{
			//Test 1: We since we have a pointer to referent, gc should not
			// clean the weakReference

			Object referent = new String("EventIteratorTest");
			/*
			 * It is absolutely amazing what you see if you replace the above
			 * with the following: Object referent = "EventIteratorTest";
			 */

			Reference reference = new WeakReference(referent);
			Assert.assertEquals(reference.get(), referent);
			Runtime.getRuntime().gc();
			Assert.assertNotNull(reference.get());

			//Test 2: We since we have a pointer to referent, gc should
			// clean the weakReference
			reference = new WeakReference(new String("EventIteratorTest"));
			Runtime.getRuntime().gc();
			Assert.assertNull(reference.get());

			//Test 3: The strong reference...
			reference = new StrongReference(new String("EventIteratorTest"));
			Assert.assertNotNull(reference.get());
			Runtime.getRuntime().gc();
			Assert.assertNotNull(reference.get());
		} catch (Throwable throwable)
		{
			//runtime exceptions are not appreciated
			Assert.fail();
		}
	}
}