/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.event.util;

import java.util.Collection;
import java.util.Iterator;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.util.EventIterator;

public class EventProducingCollection
extends EventProducer
implements Collection {
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT");
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT");
    private Collection parent = null;

    public EventProducingCollection(Collection parent) {
        this.parent = parent;
    }

    public int size() {
        return this.parent.size();
    }

    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    public void clear() {
        this.parent.clear();
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
    }

    public boolean add(Object o) {
        boolean result = this.parent.add(o);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    public boolean addAll(Collection c) {
        boolean result = this.parent.addAll(c);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.parent.containsAll(c);
    }

    public Iterator iterator() {
        return new EventIterator(this.parent.iterator());
    }

    public boolean remove(Object o) {
        boolean result = this.parent.remove(o);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public boolean removeAll(Collection c) {
        boolean result = this.parent.removeAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public boolean retainAll(Collection c) {
        boolean result = this.parent.retainAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public Object[] toArray() {
        return this.parent.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.parent.toArray(a);
    }
}

