/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventListenerMap;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.TimedEvent;
import nl.tudelft.simulation.event.ref.Reference;
import nl.tudelft.simulation.event.ref.StrongReference;
import nl.tudelft.simulation.event.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventProducer
implements EventProducerInterface,
Serializable {
    protected Map<EventType, Reference<EventListenerInterface>[]> listeners = Collections.synchronizedMap(new EventListenerMap());
    private transient Object semaphore = new Object();
    private transient EventType[] cache = null;

    private boolean checkEventType() {
        EventType[] events = this.getEventTypes();
        for (int i = 0; i < events.length; ++i) {
            for (int j = 0; j < events.length; ++j) {
                if (i == j || !events[i].equals(events[j])) continue;
                return false;
            }
        }
        return true;
    }

    public EventProducer() {
        if (!this.checkEventType()) {
            throw new RuntimeException("EventProducer failed: more events have the same short value");
        }
    }

    @Override
    public synchronized boolean addListener(EventListenerInterface listener, EventType eventType) {
        return this.addListener(listener, eventType, (short)0);
    }

    @Override
    public synchronized boolean addListener(EventListenerInterface listener, EventType eventType, boolean weak) {
        return this.addListener(listener, eventType, (short)0, weak);
    }

    @Override
    public synchronized boolean addListener(EventListenerInterface listener, EventType eventType, short position) {
        if (listener == null || position < -1) {
            return false;
        }
        return this.addListener(listener, eventType, position, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean addListener(EventListenerInterface listener, EventType eventType, short position, boolean weak) {
        if (listener == null || position < -1) {
            return false;
        }
        Object object = this.semaphore;
        synchronized (object) {
            Reference reference = null;
            reference = !weak ? new StrongReference<EventListenerInterface>(listener) : new WeakReference<EventListenerInterface>(listener);
            if (this.listeners.containsKey(eventType)) {
                Reference<EventListenerInterface>[] entries = this.listeners.get(eventType);
                for (int i = 0; i < entries.length; ++i) {
                    if (!listener.equals(entries[i].get())) continue;
                    return false;
                }
                ArrayList<Reference<EventListenerInterface>> entriesArray = new ArrayList<Reference<EventListenerInterface>>(Arrays.asList(entries));
                if (position == -1) {
                    entriesArray.add(reference);
                } else {
                    entriesArray.add(position, reference);
                }
                this.listeners.put(eventType, entriesArray.toArray(new Reference[entriesArray.size()]));
            } else {
                Reference[] entries = new Reference[]{reference};
                this.listeners.put(eventType, entries);
            }
        }
        return true;
    }

    protected synchronized EventInterface fireEvent(EventListenerInterface listener, EventInterface event) throws RemoteException {
        listener.notify(event);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized EventInterface fireEvent(EventInterface event) {
        if (this.listeners.containsKey(event.getType())) {
            Object object = this.semaphore;
            synchronized (object) {
                Reference<EventListenerInterface>[] entries = this.listeners.get(event.getType());
                for (int i = 0; i < entries.length; ++i) {
                    EventListenerInterface listener = entries[i].get();
                    try {
                        if (listener != null) {
                            this.fireEvent(listener, event);
                            continue;
                        }
                        this.removeListener(entries[i], event.getType());
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        this.removeListener(entries[i], event.getType());
                    }
                }
            }
        }
        return event;
    }

    protected synchronized byte fireEvent(EventType eventType, byte value) {
        this.fireEvent(eventType, new Byte(value));
        return value;
    }

    protected synchronized boolean fireEvent(EventType eventType, boolean value) {
        this.fireEvent(eventType, new Boolean(value));
        return value;
    }

    protected synchronized byte fireEvent(EventType eventType, byte value, double time) {
        this.fireEvent(eventType, new Byte(value), time);
        return value;
    }

    protected synchronized boolean fireEvent(EventType eventType, boolean value, double time) {
        this.fireEvent(eventType, new Boolean(value), time);
        return value;
    }

    protected synchronized double fireEvent(EventType eventType, double value) {
        this.fireEvent(eventType, new Double(value));
        return value;
    }

    protected synchronized double fireEvent(EventType eventType, double value, double time) {
        this.fireEvent(eventType, new Double(value), time);
        return value;
    }

    protected synchronized int fireEvent(EventType eventType, int value) {
        this.fireEvent(eventType, new Integer(value));
        return value;
    }

    protected synchronized int fireEvent(EventType eventType, int value, double time) {
        this.fireEvent(eventType, new Integer(value), time);
        return value;
    }

    protected synchronized long fireEvent(EventType eventType, long value) {
        this.fireEvent(eventType, new Long(value));
        return value;
    }

    protected synchronized long fireEvent(EventType eventType, long value, double time) {
        this.fireEvent(eventType, new Long(value), time);
        return value;
    }

    protected synchronized Object fireEvent(EventType eventType, Object value) {
        this.fireEvent(new Event(eventType, this, value));
        return value;
    }

    protected synchronized Object fireEvent(EventType eventType, Object value, double time) {
        this.fireEvent(new TimedEvent(eventType, this, value, time));
        return value;
    }

    protected synchronized short fireEvent(EventType eventType, short value) {
        this.fireEvent(eventType, new Short(value));
        return value;
    }

    protected synchronized short fireEvent(EventType eventType, short value, double time) {
        this.fireEvent(eventType, new Short(value), time);
        return value;
    }

    @Override
    public synchronized EventType[] getEventTypes() {
        if (this.cache != null) {
            return this.cache;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields = clazz.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                fieldList.add(declaredFields[i]);
            }
        }
        Field[] fields = fieldList.toArray(new Field[fieldList.size()]);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().equals(EventType.class)) continue;
            fields[i].setAccessible(true);
            try {
                if (result.containsKey(fields[i].getName())) continue;
                result.put(fields[i].getName(), fields[i].get(this));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.cache = result.values().toArray(new EventType[result.size()]);
        return this.cache;
    }

    protected synchronized int removeAllListeners() {
        int result = this.listeners.size();
        this.listeners = null;
        this.listeners = Collections.synchronizedMap(new EventListenerMap());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int removeAllListeners(Class ofClass) {
        HashMap<EventType, Reference<EventListenerInterface>[]> temp = new HashMap<EventType, Reference<EventListenerInterface>[]>(this.listeners);
        int result = 0;
        Object object = this.semaphore;
        synchronized (object) {
            Set keys = temp.keySet();
            for (EventType type : keys) {
                List<Object> list = Arrays.asList((Object[])this.listeners.get(type));
                for (Reference reference : list) {
                    if (!reference.getClass().isAssignableFrom(ofClass)) continue;
                    this.removeListener((EventListenerInterface)reference.get(), type);
                    ++result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeListener(EventListenerInterface listener, EventType eventType) {
        if (!this.listeners.containsKey(eventType)) {
            return false;
        }
        boolean result = false;
        Object object = this.semaphore;
        synchronized (object) {
            Reference<EventListenerInterface>[] entries = this.listeners.get(eventType);
            ArrayList<Reference<EventListenerInterface>> list = new ArrayList<Reference<EventListenerInterface>>(Arrays.asList(entries));
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Reference reference = (Reference)i.next();
                EventListenerInterface entrie = (EventListenerInterface)reference.get();
                if (entrie == null) {
                    i.remove();
                    continue;
                }
                if (!listener.equals(entrie)) continue;
                i.remove();
                result = true;
            }
            this.listeners.put(eventType, list.toArray(new Reference[list.size()]));
            if (list.size() == 0) {
                this.listeners.remove(eventType);
            }
        }
        return result;
    }

    private synchronized boolean removeListener(Reference<EventListenerInterface> reference, EventType eventType) {
        boolean success = false;
        Reference<EventListenerInterface>[] entries = this.listeners.get(eventType);
        ArrayList<Reference<EventListenerInterface>> list = new ArrayList<Reference<EventListenerInterface>>(Arrays.asList(entries));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (!((Reference)i.next()).equals(reference)) continue;
            i.remove();
            success = true;
        }
        Reference[] toArray = list.toArray(new Reference[list.size()]);
        this.listeners.put(eventType, toArray);
        if (list.size() == 0) {
            this.listeners.remove(eventType);
        }
        return success;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.semaphore = new Object();
    }
}

