/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.event.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.util.EventIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventProducingList<T>
extends EventProducer
implements List<T> {
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT");
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT");
    private List<T> parent = null;

    public EventProducingList(List<T> parent) {
        this.parent = parent;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    @Override
    public void clear() {
        this.parent.clear();
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
    }

    @Override
    public void add(int index, T element) {
        this.parent.add(index, element);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
    }

    @Override
    public boolean add(T o) {
        boolean result = this.parent.add(o);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = this.parent.addAll(c);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = this.parent.addAll(index, c);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.parent.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.parent.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.parent.indexOf(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new EventIterator<T>(this.parent.iterator());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.parent.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.parent.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.parent.listIterator(index);
    }

    @Override
    public T remove(int index) {
        T result = this.parent.remove(index);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.parent.remove(o);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean result = this.parent.removeAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean result = this.parent.retainAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public T set(int index, T element) {
        T result = this.parent.set(index, element);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.parent.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.parent.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.parent.toArray(a);
    }
}

