/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.event.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.util.EventIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventProducingSet<T>
extends EventProducer
implements Set<T> {
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT");
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT");
    private Set<T> parent = null;

    public EventProducingSet(Set<T> parent) {
        this.parent = parent;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    @Override
    public void clear() {
        this.parent.clear();
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
    }

    @Override
    public boolean add(T o) {
        boolean result = this.parent.add(o);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = this.parent.addAll(c);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.parent.containsAll(c);
    }

    @Override
    public Iterator<T> iterator() {
        return new EventIterator<T>(this.parent.iterator());
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.parent.remove(o);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean result = this.parent.removeAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean result = this.parent.retainAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.parent.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.parent.toArray(a);
    }
}

