/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.Operation;
import nl.tudelft.simulation.dsol.interpreter.classfile.ClassDescriptor;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.JumpOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.RET;
import nl.tudelft.simulation.dsol.interpreter.operations.RETURN;
import nl.tudelft.simulation.dsol.interpreter.operations.ReturnOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.WIDE;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;

public class Interpreter {
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$interpreter$Interpreter;

    protected Interpreter() {
    }

    public static Frame createFrame(Object object, AccessibleObject method, Object[] arguments) throws ClassNotFoundException, IOException {
        Object[] args = new Object[]{};
        if (arguments != null) {
            args = arguments;
        }
        ClassDescriptor classDescriptor = null;
        int modifiers = -1;
        Class<?>[] parameterTypes = null;
        if (method instanceof Method) {
            parameterTypes = ((Method)method).getParameterTypes();
            classDescriptor = ClassDescriptor.get(((Method)method).getDeclaringClass());
            modifiers = ((Method)method).getModifiers();
        } else {
            parameterTypes = ((Constructor)method).getParameterTypes();
            classDescriptor = ClassDescriptor.get(((Constructor)method).getDeclaringClass());
            modifiers = ((Constructor)method).getModifiers();
        }
        MethodDescriptor methodDescriptor = classDescriptor.getMethod(method);
        OperandStack operandStack = new OperandStack(methodDescriptor.getMaxStack());
        LocalVariable[] localVariables = LocalVariable.newInstance(methodDescriptor.getLocalVariableTable());
        int counter = 0;
        if (!Modifier.isStatic(modifiers)) {
            localVariables[counter++].setValue(object);
        }
        for (int i = 0; i < args.length; ++i) {
            localVariables[counter++].setValue(arguments[i]);
            if (!parameterTypes[i].equals(Double.TYPE) && !parameterTypes[i].equals(Long.TYPE)) continue;
            ++counter;
        }
        if (Logger.getLogLevel().intValue() <= Level.FINER.intValue()) {
            String logMessage = methodDescriptor.getMethod().toString() + "\n" + Operation.toString(methodDescriptor, methodDescriptor.getOperations());
            Logger.finer((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? (class$nl$tudelft$simulation$dsol$interpreter$Interpreter = Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter")) : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"createFrame", (String)logMessage);
        }
        return new Frame(classDescriptor.getConstantPool(), localVariables, methodDescriptor.getOperations(), operandStack, methodDescriptor);
    }

    public static Object interpret(Stack frameStack) throws InterpreterException {
        Frame frame = (Frame)frameStack.peek();
        OperandStack operandStack = frame.getOperandStack();
        Constant[] constantPool = frame.getConstantPool();
        LocalVariable[] localVariables = frame.getLocalVariables();
        MethodDescriptor methodDescriptor = frame.getMethodDescriptor();
        int operationIndex = frame.getReturnPosition();
        boolean log = Logger.getLogLevel().intValue() <= Level.FINEST.intValue();
        while (true) {
            Operation operation = frame.getOperations()[operationIndex];
            if (log) {
                Logger.finest((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter") : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"interpret", (String)("" + operandStack));
                Logger.finest((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter") : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"interpret", (String)("" + frameStack.size() + " " + operation));
            }
            if (operation instanceof WIDE) {
                operation = ((WIDE)operation).getTarget();
            }
            if (operation instanceof VoidOperation) {
                ((VoidOperation)operation).execute(operandStack, constantPool, localVariables);
                ++operationIndex;
                continue;
            }
            if (operation instanceof InvokeOperation) {
                Frame childFrame = ((InvokeOperation)operation).execute(frame);
                ++operationIndex;
                if (childFrame == null) continue;
                frame.setReturnPosition(operationIndex);
                if (frame.isPaused()) {
                    return frame;
                }
                frame = childFrame;
                frameStack.push(frame);
                operandStack = frame.getOperandStack();
                constantPool = frame.getConstantPool();
                localVariables = frame.getLocalVariables();
                methodDescriptor = frame.getMethodDescriptor();
                operationIndex = 0;
                continue;
            }
            if (operation instanceof JumpOperation) {
                int offset;
                int bytePosition = offset = ((JumpOperation)operation).execute(operandStack, constantPool, localVariables);
                if (!(operation instanceof RET)) {
                    bytePosition += methodDescriptor.getBytePosition(operationIndex);
                }
                operationIndex = methodDescriptor.getOperationIndex(bytePosition);
                continue;
            }
            if (!(operation instanceof ReturnOperation)) continue;
            Object result = ((ReturnOperation)operation).execute(frame);
            frameStack.pop();
            if (frameStack.isEmpty()) {
                return result;
            }
            frame = (Frame)frameStack.peek();
            operandStack = frame.getOperandStack();
            constantPool = frame.getConstantPool();
            localVariables = frame.getLocalVariables();
            methodDescriptor = frame.getMethodDescriptor();
            operationIndex = frame.getReturnPosition();
            if (operation instanceof RETURN) continue;
            operandStack.push(result);
        }
    }

    public static Object invoke(Object object, String methodName, Object[] arguments, Class[] argumentTypes) {
        try {
            Executable method = null;
            method = !methodName.equals("<init>") ? (object instanceof Class ? ClassUtil.resolveMethod((Class)((Class)object), (String)methodName, (Class[])argumentTypes) : ClassUtil.resolveMethod(object.getClass(), (String)methodName, (Class[])argumentTypes)) : object.getClass().getDeclaredConstructor(argumentTypes);
            return Interpreter.invoke(object, method, arguments);
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public static Object invoke(Object object, AccessibleObject method, Object[] arguments) throws InterpreterException {
        if (Logger.getLogLevel().intValue() <= Level.FINE.intValue()) {
            Logger.fine((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? (class$nl$tudelft$simulation$dsol$interpreter$Interpreter = Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter")) : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"invoke", (String)method.toString());
        }
        try {
            if (method instanceof Constructor && Modifier.isNative(((Constructor)method).getModifiers())) {
                return ((Constructor)method).newInstance(arguments);
            }
            if (method instanceof Method && Modifier.isNative(((Method)method).getModifiers())) {
                return ((Method)method).invoke(object, arguments);
            }
            Stack<Frame> frameStack = new Stack<Frame>();
            frameStack.push(Interpreter.createFrame(object, method, arguments));
            return Interpreter.interpret(frameStack);
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InputStream stream = URLResource.getResourceAsStream((String)"/interpreter.properties");
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                Logger.setLogLevel((Level)Level.parse(properties.getProperty("interpreter.logLevel")));
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor == null ? (class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor = Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor")) : class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor), (String)"<clinit>", (Throwable)exception);
        }
    }
}

