/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantDouble;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantLong;
import nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor;

public class ClassDescriptor {
    private static final Map REPOSITORY = new HashMap();
    private Constant[] constantPool = null;
    private Map methods = new HashMap();
    private Class javaClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassDescriptor get(Class clazz) throws IOException, ClassNotFoundException {
        Map map = REPOSITORY;
        synchronized (map) {
            if (REPOSITORY.containsKey(clazz)) {
                return (ClassDescriptor)REPOSITORY.get(clazz);
            }
            ClassDescriptor classDescriptor = new ClassDescriptor(clazz);
            REPOSITORY.put(clazz, classDescriptor);
            return classDescriptor;
        }
    }

    private ClassDescriptor(Class javaClass) throws IOException, ClassNotFoundException {
        this.javaClass = javaClass;
        ClassLoader classLoader = javaClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        this.readClass(new DataInputStream(classLoader.getResourceAsStream(javaClass.getName().replace('.', '/') + ".class")));
    }

    public MethodDescriptor getMethod(AccessibleObject method) {
        return (MethodDescriptor)this.methods.get(method);
    }

    public Constant[] getConstantPool() {
        return this.constantPool;
    }

    public MethodDescriptor[] getMethods() {
        return this.methods.values().toArray(new MethodDescriptor[this.methods.size()]);
    }

    private void readClass(DataInput dataInput) throws IOException, ClassNotFoundException {
        dataInput.skipBytes(8);
        this.readConstantPool(dataInput);
        dataInput.skipBytes(6);
        int interfacesCount = dataInput.readUnsignedShort();
        dataInput.skipBytes(2 * interfacesCount);
        int fieldCount = dataInput.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            dataInput.skipBytes(6);
            int attributeCount = dataInput.readUnsignedShort();
            for (int j = 0; j < attributeCount; ++j) {
                dataInput.skipBytes(2);
                dataInput.skipBytes(dataInput.readInt());
            }
        }
        int methodCount = dataInput.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            MethodDescriptor methodDescriptor = new MethodDescriptor(dataInput, this.constantPool);
            AccessibleObject method = this.parseMethod(methodDescriptor.getName(), methodDescriptor.getMethodSignature().getParameterTypes());
            methodDescriptor.setMethod(method);
            this.methods.put(method, methodDescriptor);
        }
    }

    private void readConstantPool(DataInput dataInput) throws IOException {
        this.constantPool = new Constant[dataInput.readUnsignedShort()];
        for (int i = 1; i < this.constantPool.length; ++i) {
            this.constantPool[i] = Constant.readConstant(this.constantPool, dataInput);
            if (!(this.constantPool[i] instanceof ConstantDouble) && !(this.constantPool[i] instanceof ConstantLong)) continue;
            ++i;
        }
    }

    private AccessibleObject parseMethod(String methodName, Class[] argumentClasses) {
        try {
            if (methodName.equals("<clinit>")) {
                return null;
            }
            if (!methodName.equals("<init>")) {
                return this.javaClass.getDeclaredMethod(methodName, argumentClasses);
            }
            return this.javaClass.getDeclaredConstructor(argumentClasses);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

