/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.Operation;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantUTF8;
import nl.tudelft.simulation.dsol.interpreter.classfile.ExceptionEntry;
import nl.tudelft.simulation.dsol.interpreter.classfile.LineNumber;
import nl.tudelft.simulation.dsol.interpreter.classfile.LocalVariableDescriptor;
import nl.tudelft.simulation.dsol.interpreter.operations.FactoryInterface;
import nl.tudelft.simulation.dsol.interpreter.operations.InterpreterFactory;
import nl.tudelft.simulation.language.reflection.MethodSignature;
import nl.tudelft.simulation.logger.Logger;

public class MethodDescriptor {
    private static FactoryInterface operationFactory = new InterpreterFactory();
    private int[] bytePositions = new int[0];
    private Constant[] constantPool = new Constant[0];
    private ExceptionEntry[] exceptionTable = new ExceptionEntry[0];
    private LineNumber[] lineNumberTable = new LineNumber[0];
    private LocalVariableDescriptor[] localVariableTable = new LocalVariableDescriptor[0];
    private int maxStack = -1;
    private AccessibleObject method = null;
    private MethodSignature methodSignature = null;
    private String name;
    private Operation[] operations = new Operation[0];
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor;

    public MethodDescriptor(DataInput dataInput, Constant[] constantPool) throws IOException {
        this.constantPool = constantPool;
        this.readMethod(dataInput);
    }

    public int getBytePosition(int operationIndex) {
        return this.bytePositions[operationIndex];
    }

    public ExceptionEntry[] getExceptionTable() {
        return this.exceptionTable;
    }

    public LineNumber[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public LocalVariableDescriptor[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public AccessibleObject getMethod() {
        return this.method;
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public String getName() {
        return this.name;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public int getOperationIndex(int bytePosition) {
        for (int i = 0; i < this.bytePositions.length; ++i) {
            if (this.bytePositions[i] != bytePosition) continue;
            return i;
        }
        throw new NoSuchElementException("At bytePosition(" + bytePosition + ") no operation starts");
    }

    public Operation getOperation(int bytePosition) {
        for (int i = 0; i < this.bytePositions.length; ++i) {
            if (this.bytePositions[i] != bytePosition) continue;
            return this.operations[i];
        }
        return null;
    }

    public void setMethod(AccessibleObject method) {
        this.method = method;
    }

    private void readMethod(DataInput dataInput) throws IOException {
        dataInput.skipBytes(2);
        this.name = ((ConstantUTF8)this.constantPool[dataInput.readUnsignedShort()]).getValue();
        this.methodSignature = new MethodSignature(((ConstantUTF8)this.constantPool[dataInput.readUnsignedShort()]).getValue());
        int attributeCount = dataInput.readUnsignedShort();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = ((ConstantUTF8)this.constantPool[dataInput.readUnsignedShort()]).getValue();
            if (attributeName.equals("Code")) {
                this.readCodeAttribute(dataInput);
                continue;
            }
            dataInput.skipBytes(dataInput.readInt());
        }
    }

    private void readCodeAttribute(DataInput dataInput) throws IOException {
        int position;
        Operation operation;
        dataInput.skipBytes(4);
        this.maxStack = dataInput.readUnsignedShort();
        this.localVariableTable = new LocalVariableDescriptor[dataInput.readUnsignedShort()];
        int codeLength = dataInput.readInt();
        ArrayList<Operation> code = new ArrayList<Operation>();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (position = 0; position < codeLength; position += operation.getByteLength()) {
            operation = operationFactory.readOperation(dataInput, position);
            code.add(operation);
            positions.add(new Integer(position));
        }
        if (position != codeLength) {
            throw new InterpreterException(" byteCode readmethod pos" + position + "!= codeL" + codeLength);
        }
        this.operations = code.toArray(new Operation[code.size()]);
        this.bytePositions = new int[positions.size()];
        int line = 0;
        Iterator i = positions.iterator();
        while (i.hasNext()) {
            this.bytePositions[line] = (Integer)i.next();
            ++line;
        }
        this.exceptionTable = new ExceptionEntry[dataInput.readUnsignedShort()];
        for (int i2 = 0; i2 < this.exceptionTable.length; ++i2) {
            this.exceptionTable[i2] = new ExceptionEntry(dataInput, this.constantPool);
        }
        int attributeCount = dataInput.readUnsignedShort();
        for (int i3 = 0; i3 < attributeCount; ++i3) {
            String attributeName = ((ConstantUTF8)this.constantPool[dataInput.readUnsignedShort()]).getValue();
            if (attributeName.equals("LineNumberTable")) {
                this.readLineNumberTable(dataInput);
                continue;
            }
            if (attributeName.equals("LocalVariableTable")) {
                this.readLocalVariableTable(dataInput);
                continue;
            }
            dataInput.skipBytes(dataInput.readInt());
        }
    }

    private void readLineNumberTable(DataInput dataInput) throws IOException {
        dataInput.skipBytes(4);
        this.lineNumberTable = new LineNumber[dataInput.readUnsignedShort()];
        for (int i = 0; i < this.lineNumberTable.length; ++i) {
            this.lineNumberTable[i] = new LineNumber(dataInput);
        }
    }

    private void readLocalVariableTable(DataInput dataInput) throws IOException {
        dataInput.skipBytes(4);
        int variables = dataInput.readUnsignedShort();
        for (int i = 0; i < variables; ++i) {
            LocalVariableDescriptor variable;
            this.localVariableTable[variable.getIndex()] = variable = new LocalVariableDescriptor(dataInput, this.constantPool);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InputStream stream = (class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor == null ? (class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor = MethodDescriptor.class$("nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor")) : class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor).getResourceAsStream("/interpreter.properties");
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                String factoryClassName = properties.getProperty("interpreter.operation.factory");
                operationFactory = (FactoryInterface)Class.forName(factoryClassName).newInstance();
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor == null ? (class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor = MethodDescriptor.class$("nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor")) : class$nl$tudelft$simulation$dsol$interpreter$classfile$MethodDescriptor), (String)"<clinit>", (Throwable)exception);
        }
    }
}

