/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantFieldref;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.language.reflection.ClassUtil;

public class GETFIELD
extends VoidOperation {
    public static final int OP = 180;
    private int index = -1;

    public GETFIELD(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        try {
            ConstantFieldref constantFieldref = (ConstantFieldref)constantPool[this.index];
            Object objectRef = stack.pop();
            Field field = ClassUtil.resolveField((Object)objectRef, (String)constantFieldref.getConstantNameAndType().getName());
            ((AccessibleObject)field).setAccessible(true);
            stack.push(field.get(objectRef));
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 180;
    }
}

