/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations.reflection;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantMethodref;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class INVOKEVIRTUAL
extends InvokeOperation {
    public static final int OP = 182;
    protected int index = -1;

    public INVOKEVIRTUAL(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame execute(Frame frame) {
        try {
            ConstantMethodref constantMethodref = (ConstantMethodref)frame.getConstantPool()[this.index];
            Class[] parameterTypes = new MethodSignature(constantMethodref.getConstantNameAndType().getDescriptor()).getParameterTypes();
            OperandStack operandStack = frame.getOperandStack();
            synchronized (operandStack) {
                Object objectRef = frame.getOperandStack().peek(parameterTypes.length);
                Method method = ClassUtil.resolveMethod((Object)objectRef, (String)constantMethodref.getConstantNameAndType().getName(), (Class[])parameterTypes);
                Object[] args = new Object[parameterTypes.length];
                for (int i = args.length - 1; i > -1; --i) {
                    args[i] = Primitive.cast((Class)parameterTypes[i], (Object)frame.getOperandStack().pop());
                }
                frame.getOperandStack().pop();
                return this.execute(frame, objectRef, method, args);
            }
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public Frame execute(Frame frame, Object objectRef, Method method, Object[] arguments) throws Exception {
        ((AccessibleObject)method).setAccessible(true);
        Object result = method.invoke(objectRef, arguments);
        if (!method.getReturnType().equals(Void.TYPE)) {
            frame.getOperandStack().push(result);
        }
        return null;
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 182;
    }
}

