/*
 * @(#) IntrospectingTableModelInterface.java Apr 15, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.introspection.gui;

import javax.swing.table.TableModel;

import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;

/**
 * Defines the minimum contract for a TableModel providing additional
 * introspection services. The contract is used to facilitate communication
 * between an {see ObjectJTable}and an introspecting TableModel, especially to
 * allow an ObjectJTable to create additional ObjectJTable instances.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a
 *         href="http://web.eur.nl/fbk/dep/dep1/Introduction/Staff/People/Lang">Niels
 *         Lang </a><a
 *         href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.1 Apr 15, 2004
 * @since 1.4
 */
public interface IntrospectingTableModelInterface extends TableModel
{
	/**
	 * Returns the Property instance generated by this
	 * IntrospectingTableModelInterface for the property 'propertyName'.
	 * 
	 * @param propertyName The name of the Property to be returned
	 * @return The Property corresponding to 'propertyName', null if the
	 *         property could not be found.
	 */
	Property getProperty(String propertyName);

	/**
	 * @return The introspector instance used by this introspecting TableModel.
	 */
	Introspector getIntrospector();

	/**
	 * gets the class of the the object at row,column.
	 * 
	 * @param rowIndex the rowNumber
	 * @param columnIndex the columnNumber
	 * @return The type of the value in cell 'rowIndex', 'columnIndex'
	 */
	Class getTypeAt(int rowIndex, int columnIndex);

	/**
	 * Returns a reference to this model's modelManager, {see ModelManager}.
	 * 
	 * @return the model manager
	 */
	ModelManager getModelManager();
}