/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.beans;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanProperty;
import nl.tudelft.simulation.logger.Logger;

public class BeanIntrospector
implements Introspector {
    public Property[] getProperties(Object introspected) {
        HashSet<BeanProperty> props = new HashSet<BeanProperty>();
        try {
            BeanInfo info = java.beans.Introspector.getBeanInfo(introspected.getClass());
            PropertyDescriptor[] descrips = info.getPropertyDescriptors();
            for (int i = 0; i < descrips.length; ++i) {
                props.add(new BeanProperty(introspected, descrips[i]));
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getProperties", (Throwable)e);
        }
        return props.toArray(new Property[props.size()]);
    }

    public Property getProperty(Object introspected, String property) {
        try {
            BeanInfo info = java.beans.Introspector.getBeanInfo(introspected.getClass());
            PropertyDescriptor[] descrips = info.getPropertyDescriptors();
            for (int i = 0; i < descrips.length; ++i) {
                if (!descrips[i].getName().equals(property)) continue;
                return new BeanProperty(introspected, descrips[i]);
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getProperty", (Throwable)e);
        }
        throw new IllegalArgumentException("Property '" + property + "' not found for " + introspected);
    }

    public String[] getPropertyNames(Object introspected) {
        HashSet<String> props = new HashSet<String>();
        try {
            BeanInfo info = java.beans.Introspector.getBeanInfo(introspected.getClass());
            PropertyDescriptor[] descrips = info.getPropertyDescriptors();
            for (int i = 0; i < descrips.length; ++i) {
                props.add(descrips[i].getName());
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getPropertyNames", (Throwable)e);
        }
        return props.toArray(new String[props.size()]);
    }
}

