/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import nl.tudelft.simulation.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.introspection.gui.ExpandButton;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ModelManager;
import nl.tudelft.simulation.introspection.table.DynamicTableModel;
import nl.tudelft.simulation.logger.Logger;

public class CollectionTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface,
DynamicTableModel {
    protected Map instances = Collections.synchronizedMap(new HashMap(20));
    protected List keys = Collections.synchronizedList(new ArrayList(20));
    private Class componentType = null;
    private static final String[] COLUMNS = new String[]{"#", "+", "Instance"};
    private List buttons = Collections.synchronizedList(new ArrayList(20));
    private Property parentProperty;
    private Introspector introspector;
    private ModelManager manager = new DefaultModelManager();
    private int maxKey = 0;
    static /* synthetic */ Class class$nl$tudelft$simulation$introspection$gui$ExpandButton;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public CollectionTableModel(Property parentProperty) {
        this(parentProperty, new BeanIntrospector());
    }

    public CollectionTableModel(Property parentProperty, Introspector introspector) {
        int i;
        Object values = parentProperty.getValue();
        if (values.getClass().isArray()) {
            for (i = 0; i < ((Object[])values).length; ++i) {
                this.addValue(((Object[])values)[i]);
            }
        }
        if (values instanceof Collection) {
            Iterator i2 = ((Collection)values).iterator();
            while (i2.hasNext()) {
                this.addValue(i2.next());
            }
        }
        this.parentProperty = parentProperty;
        this.introspector = introspector;
        for (i = 0; i < this.instances.size(); ++i) {
            this.buttons.add(new ExpandButton(this.getProperty(i), this));
        }
    }

    private void addValue(Object value) {
        Integer nextKey = new Integer(this.maxKey++);
        this.keys.add(nextKey);
        this.instances.put(nextKey, value);
    }

    public int getRowCount() {
        return this.instances.size();
    }

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return new Integer(rowIndex);
        }
        if (columnIndex == 1) {
            return this.buttons.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex));
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            Integer key = (Integer)this.keys.get(rowIndex);
            this.instances.put(key, aValue);
        }
        this.update();
    }

    private void update() {
        ArrayList newValue = new ArrayList(this.keys.size());
        for (int i = 0; i < this.keys.size(); ++i) {
            newValue.add(this.instances.get(this.keys.get(i)));
        }
        this.parentProperty.setValue(newValue);
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return class$nl$tudelft$simulation$introspection$gui$ExpandButton == null ? (class$nl$tudelft$simulation$introspection$gui$ExpandButton = CollectionTableModel.class$("nl.tudelft.simulation.introspection.gui.ExpandButton")) : class$nl$tudelft$simulation$introspection$gui$ExpandButton;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = CollectionTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Property getProperty(String propertyName) {
        int index = Integer.parseInt(propertyName);
        return this.getProperty(index);
    }

    protected Property getProperty(int index) {
        return new CollectionProperty((Integer)this.keys.get(index), this.parentProperty.getName());
    }

    public void createRow() {
        if (this.componentType == null) {
            this.componentType = this.parentProperty.getComponentType();
            if (this.componentType == null) {
                return;
            }
        }
        try {
            Constructor instanceConstructor = this.componentType.getConstructor(new Class[0]);
            Object instance = instanceConstructor.newInstance(new Object[0]);
            this.addValue(instance);
            this.buttons.add(new ExpandButton(this.getProperty(this.instances.size() - 1), this));
            this.update();
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"createRow", (String)("Could not instantiate new instance: " + e.getMessage()));
        }
    }

    public void createRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.createRow();
        }
    }

    public void deleteRow(int index) {
        Integer deletionKey = (Integer)this.keys.get(index);
        this.instances.remove(deletionKey);
        this.keys.remove(index);
        this.buttons.remove(index);
        this.update();
    }

    public synchronized void deleteRows(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.deleteRow(indices[i]);
        }
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public Class getTypeAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = CollectionTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        if (columnIndex == 1) {
            return class$nl$tudelft$simulation$introspection$gui$ExpandButton == null ? (class$nl$tudelft$simulation$introspection$gui$ExpandButton = CollectionTableModel.class$("nl.tudelft.simulation.introspection.gui.ExpandButton")) : class$nl$tudelft$simulation$introspection$gui$ExpandButton;
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex)).getClass();
        }
        return null;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    public ModelManager getModelManager() {
        return this.manager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CollectionProperty
    extends AbstractProperty
    implements Property {
        private final Integer key;
        private final String name;

        public CollectionProperty(Integer key, String name) {
            this.key = key;
            this.name = name;
        }

        public Object getInstance() {
            return CollectionTableModel.this.instances.values();
        }

        public String getName() {
            return this.name + "[" + CollectionTableModel.this.keys.indexOf(this.key) + "]";
        }

        public Class getType() {
            return CollectionTableModel.this.instances.get(this.key).getClass();
        }

        public Object getValue() {
            return CollectionTableModel.this.instances.get(this.key);
        }

        public boolean isEditable() {
            return true;
        }

        protected void setRegularValue(Object value) {
            throw new IllegalArgumentException(this + " is only supposed to be" + " set to composite values." + "A program is not supposed to arrive here.");
        }

        public String toString() {
            return "Coll.Prop, key:" + this.key;
        }
    }
}

