/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ObjectJTableInterface;
import nl.tudelft.simulation.introspection.gui.SortingObjectTableModel;
import nl.tudelft.simulation.introspection.gui.UpdateTimer;
import nl.tudelft.simulation.introspection.mapping.CellPresentationConfiguration;
import nl.tudelft.simulation.introspection.mapping.DefaultConfiguration;
import nl.tudelft.simulation.introspection.sortable.SortDefinition;
import nl.tudelft.simulation.introspection.sortable.SortingTableHeader;

public class ObjectJTable
extends JTable
implements ObjectJTableInterface {
    private static UpdateTimer updateTimer = new UpdateTimer(100L);
    protected boolean hasShown = false;
    private IntrospectingTableModelInterface introspectionTableModel;

    public ObjectJTable(IntrospectingTableModelInterface dm) {
        this(dm, DefaultConfiguration.getDefaultConfiguration());
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, CellPresentationConfiguration config) {
        super(new SortingObjectTableModel(dm));
        this.init(config, dm);
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, TableColumnModel cm) {
        super(new SortingObjectTableModel(dm), cm);
        this.init(DefaultConfiguration.getDefaultConfiguration(), dm);
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, TableColumnModel cm, ListSelectionModel sm) {
        super(new SortingObjectTableModel(dm), cm, sm);
        this.init(DefaultConfiguration.getDefaultConfiguration(), dm);
    }

    private void init(CellPresentationConfiguration config, IntrospectingTableModelInterface model) {
        this.introspectionTableModel = model;
        this.setConfig(config);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        SortingTableHeader header = new SortingTableHeader(new SortDefinition[]{new SortDefinition(0, true)});
        this.setTableHeader(header);
        ((JTableHeader)header).setColumnModel(this.getColumnModel());
        updateTimer.add(this);
    }

    private void setConfig(CellPresentationConfiguration config) {
        this.addHierarchyListener(new ParentListener());
        Class[][] renderers = config.getRenderers();
        Class[][] editors = config.getEditors();
        try {
            int i;
            for (i = 0; i < renderers.length; ++i) {
                this.setDefaultRenderer(renderers[i][0], (TableCellRenderer)renderers[i][1].newInstance());
            }
            for (i = 0; i < editors.length; ++i) {
                this.setDefaultEditor(editors[i][0], (TableCellEditor)editors[i][1].newInstance());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Configuration " + config + "failed, " + "probably invalid classes.");
        }
        this.getColumn(this.getColumnName(0)).setPreferredWidth(70);
        this.getColumn(this.getColumnName(1)).setMaxWidth(25);
        this.getColumn(this.getColumnName(2)).setPreferredWidth(450);
        this.setAutoResizeMode(0);
    }

    public IntrospectingTableModelInterface getIntrospectingTableModel() {
        return this.introspectionTableModel;
    }

    private class ParentListener
    implements HierarchyListener {
        private ParentListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 2L) {
                if (!ObjectJTable.this.hasShown && ObjectJTable.this.isDisplayable()) {
                    ObjectJTable.this.hasShown = true;
                    return;
                }
                if (ObjectJTable.this.hasShown && !ObjectJTable.this.isDisplayable()) {
                    ObjectJTable.this.getModel().removeTableModelListener(ObjectJTable.this);
                }
            }
        }
    }
}

