/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import nl.tudelft.simulation.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.introspection.gui.ExpandButton;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ModelManager;
import nl.tudelft.simulation.logger.Logger;

public class ObjectTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface {
    protected Property[] properties = new Property[0];
    private static String[] columns = new String[]{"Property", "+", "Value"};
    private ExpandButton[] buttons;
    private Introspector introspector = null;
    private ModelManager manager = new DefaultModelManager();
    static /* synthetic */ Class class$nl$tudelft$simulation$introspection$gui$ExpandButton;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public ObjectTableModel(Object bean) {
        this(bean, new BeanIntrospector());
    }

    public ObjectTableModel(Object object, Introspector introspector) {
        this.properties = introspector.getProperties(object);
        this.buttons = new ExpandButton[this.properties.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new ExpandButton(this.properties[i], this);
        }
        this.introspector = introspector;
    }

    public int getRowCount() {
        return this.properties.length;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Property requested = this.properties[rowIndex];
        if (columnIndex == 0) {
            return requested.getName();
        }
        if (columnIndex == 1) {
            return this.buttons[rowIndex];
        }
        if (columnIndex == 2) {
            return requested.getValue();
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        return columns[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return true;
        }
        if (columnIndex == 2) {
            return this.properties[rowIndex].isEditable() && !this.properties[rowIndex].getType().isArray();
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 2 || !this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        Property requested = this.properties[rowIndex];
        try {
            requested.setValue(aValue);
        }
        catch (IllegalArgumentException exception) {
            Logger.warning((Object)this, (String)"setValueAt", (Throwable)exception);
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return class$nl$tudelft$simulation$introspection$gui$ExpandButton == null ? (class$nl$tudelft$simulation$introspection$gui$ExpandButton = ObjectTableModel.class$("nl.tudelft.simulation.introspection.gui.ExpandButton")) : class$nl$tudelft$simulation$introspection$gui$ExpandButton;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = ObjectTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Class getTypeAt(int rowIndex, int columnIndex) {
        Property requested = this.properties[rowIndex];
        if (columnIndex == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = ObjectTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        if (columnIndex == 1) {
            return class$nl$tudelft$simulation$introspection$gui$ExpandButton == null ? (class$nl$tudelft$simulation$introspection$gui$ExpandButton = ObjectTableModel.class$("nl.tudelft.simulation.introspection.gui.ExpandButton")) : class$nl$tudelft$simulation$introspection$gui$ExpandButton;
        }
        if (columnIndex == 2) {
            return requested.getType();
        }
        return null;
    }

    protected int getPropertyIndex(String property) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getName().equalsIgnoreCase(property)) continue;
            return i;
        }
        return -1;
    }

    public Property getProperty(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index == -1) {
            return null;
        }
        return this.properties[index];
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    public ModelManager getModelManager() {
        return this.manager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

