/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.sortable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.table.DefaultTableCellRenderer;

public class SortingHeaderCell
extends DefaultTableCellRenderer {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    protected static int instanceCounter = 0;
    private int sortMode = 0;
    private int id = instanceCounter;

    public SortingHeaderCell(int sort) {
        this.sortMode = sort;
        this.setHorizontalAlignment(0);
        this.setBackground(Color.LIGHT_GRAY);
        this.id = instanceCounter++;
    }

    public SortingHeaderCell() {
        this(0);
    }

    public void changeSort() {
        this.sortMode = (this.sortMode + 1) % 3;
        ((Component)this).repaint();
    }

    public void setSort(int sort) {
        this.sortMode = sort;
    }

    public int getSort() {
        return this.sortMode;
    }

    public boolean isSorted() {
        return this.sortMode != 0;
    }

    public boolean isAscendingSorted() {
        return this.sortMode == 1;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.GRAY);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.sortMode == 2) {
            g.fillPolygon(new int[]{width - 14, width - 9, width - 4}, new int[]{4, height - 4, 4}, 3);
        } else if (this.sortMode == 1) {
            g.fillPolygon(new int[]{width - 14, width - 9, width - 4}, new int[]{height - 4, 4, height - 4}, 3);
        }
    }

    protected void setValue(Object value) {
        super.setValue(value);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public String toString() {
        return "SortingHeaderRenderer: " + this.id;
    }
}

