/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProperty
extends AbstractProperty
implements Property {
    private Object bean = null;
    private PropertyDescriptor descriptor = null;

    protected BeanProperty(Object bean, PropertyDescriptor descriptor) {
        this.bean = bean;
        this.descriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Class<?> getType() {
        return this.descriptor.getPropertyType();
    }

    @Override
    protected void setRegularValue(Object values) {
        Class<?> type = this.descriptor.getPropertyType();
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        Object newValue = values;
        if (editor != null) {
            if (values instanceof String) {
                editor.setAsText((String)values);
            } else {
                editor.setValue(values);
            }
            newValue = editor.getValue();
        }
        Method writeMethod = this.descriptor.getWriteMethod();
        try {
            writeMethod.invoke(this.bean, newValue);
        }
        catch (Throwable throwable) {
            Logger.warning((Object)this, (String)"setRegularValue", (Throwable)throwable);
        }
    }

    @Override
    public Object getValue() {
        Object result = null;
        Method readMethod = this.descriptor.getReadMethod();
        try {
            if (readMethod != null) {
                result = readMethod.invoke(this.bean, new Object[0]);
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)("getValue of " + this.getName()), (Throwable)exception);
        }
        return result;
    }

    @Override
    public Object getInstance() {
        return this.bean;
    }

    @Override
    public boolean isEditable() {
        return this.descriptor.getWriteMethod() != null;
    }
}

