/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.fields;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.fields.FieldProperty;
import nl.tudelft.simulation.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldIntrospector
implements Introspector {
    private boolean useDeepIntrospection = true;

    public FieldIntrospector() {
        this(false);
    }

    public FieldIntrospector(boolean useDeepIntrospection) {
        this.useDeepIntrospection = useDeepIntrospection;
    }

    @Override
    public Property[] getProperties(Object introspected) {
        HashSet<FieldProperty> props = new HashSet<FieldProperty>();
        try {
            Field[] fields = this.collectFields(introspected.getClass());
            for (int i = 0; i < fields.length; ++i) {
                props.add(new FieldProperty(introspected, fields[i]));
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getProperties", (Throwable)e);
        }
        return props.toArray(new Property[props.size()]);
    }

    private Field[] collectFields(Class clasz) {
        ArrayList<Field> fields = new ArrayList<Field>(10);
        this.addFields(fields, clasz, this.useDeepIntrospection);
        return fields.toArray(new Field[fields.size()]);
    }

    private void addFields(List<Field> fieldList, Class<?> clasz, boolean iterate) {
        fieldList.addAll(Arrays.asList(clasz.getDeclaredFields()));
        if (iterate && clasz.getSuperclass() != null) {
            this.addFields(fieldList, clasz.getSuperclass(), iterate);
        }
    }

    @Override
    public Property getProperty(Object introspected, String property) {
        try {
            Field[] fields = this.collectFields(introspected.getClass());
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(property)) continue;
                return new FieldProperty(introspected, fields[i]);
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getProperty", (Throwable)e);
        }
        throw new IllegalArgumentException("Property '" + property + "' not found for " + introspected);
    }

    @Override
    public String[] getPropertyNames(Object introspected) {
        HashSet<String> props = new HashSet<String>();
        try {
            Field[] fields = this.collectFields(introspected.getClass());
            for (int i = 0; i < fields.length; ++i) {
                props.add(fields[i].getName());
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getPropertyNames", (Throwable)e);
        }
        return props.toArray(new String[props.size()]);
    }
}

