/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.fields;

import java.lang.reflect.Field;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldProperty
extends AbstractProperty
implements Property {
    private Object owner = null;
    private Field descriptor = null;
    private boolean editable = false;

    public FieldProperty(Object owner, Field descriptor, boolean editable) {
        this.owner = owner;
        this.descriptor = descriptor;
        this.descriptor.setAccessible(true);
        this.editable = editable;
    }

    public FieldProperty(Object owner, Field descriptor) {
        this(owner, descriptor, true);
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Class<?> getType() {
        return this.descriptor.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRegularValue(Object value) {
        Class<?> type = this.descriptor.getType();
        if (!type.isInstance(value) || !this.editable) {
            throw new IllegalArgumentException("Cannot assign " + value + " to " + this.owner + ", " + this.descriptor);
        }
        Object object = this.owner;
        synchronized (object) {
            try {
                this.descriptor.set(this.owner, value);
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"setRegularValue", (Throwable)exception);
            }
        }
    }

    @Override
    public Object getValue() {
        try {
            return this.descriptor.get(this.owner);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"getValue", (Throwable)exception);
            return null;
        }
    }

    @Override
    public Object getInstance() {
        return this.owner;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }
}

