/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.gui.CollectionTableModel;
import nl.tudelft.simulation.introspection.gui.ICellPresentationConfigProvider;
import nl.tudelft.simulation.introspection.gui.IntroSpectionDialog;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ModelManager;
import nl.tudelft.simulation.introspection.gui.ObjectJTable;
import nl.tudelft.simulation.introspection.gui.ObjectTableModel;
import nl.tudelft.simulation.introspection.mapping.CellPresentationConfiguration;
import nl.tudelft.simulation.introspection.mapping.DefaultConfiguration;
import nl.tudelft.simulation.logger.Logger;

public class ExpandButton
extends JButton {
    private JTable myTable;
    private final Property PROPERTY;
    private final IntrospectingTableModelInterface MODEL;

    public ExpandButton(Property property, IntrospectingTableModelInterface model) {
        super("+");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.PROPERTY = property;
        this.MODEL = model;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpandButton.this.showTable();
            }
        });
    }

    public void setMyJTable(JTable table) {
        this.myTable = table;
    }

    public void showTable() {
        if (this.PROPERTY.getValue() == null) {
            return;
        }
        if (this.myTable != null) {
            Window parentWindow = SwingUtilities.getWindowAncestor(this);
            new IntroSpectionDialog(parentWindow, this.PROPERTY.getName() + ", " + this.PROPERTY.getValue(), this.instantiateTable());
        } else {
            new IntroSpectionDialog(this.PROPERTY.getName() + ", " + this.PROPERTY.getValue(), this.instantiateTable());
        }
    }

    private JTable instantiateTable() {
        IntrospectingTableModelInterface newModel = null;
        ModelManager manager = this.MODEL.getModelManager();
        Introspector introspector = this.MODEL.getIntrospector();
        try {
            Constructor c;
            Class modelClass = null;
            if (this.PROPERTY.isCollection()) {
                modelClass = manager.getDefaultCollectionObjectTableModel();
                c = modelClass.getConstructor(Property.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY, introspector);
            } else {
                modelClass = manager.getDefaultObjectTableModel();
                c = modelClass.getConstructor(Object.class, Introspector.class);
                newModel = (IntrospectingTableModelInterface)c.newInstance(this.PROPERTY.getValue(), introspector);
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"instantiate", (String)(" could not instantiate parent tablemodel, using default. Exception:" + exception.getMessage()));
            newModel = this.PROPERTY.isCollection() ? new CollectionTableModel(this.PROPERTY) : new ObjectTableModel(this.PROPERTY.getValue());
        }
        CellPresentationConfiguration config = DefaultConfiguration.getDefaultConfiguration();
        if (this.myTable instanceof ICellPresentationConfigProvider) {
            config = ((ICellPresentationConfigProvider)((Object)this.myTable)).getCellPresentationConfiguration();
        }
        ObjectJTable result = new ObjectJTable(newModel, config);
        newModel.getModelManager().setDefaultCollectionObjectTableModel(manager.getDefaultCollectionObjectTableModel());
        newModel.getModelManager().setDefaultObjectTableModel(manager.getDefaultObjectTableModel());
        return result;
    }
}

