/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ObjectJTable;
import nl.tudelft.simulation.introspection.gui.ObjectJTableInterface;
import nl.tudelft.simulation.introspection.gui.ObjectTableModel;
import nl.tudelft.simulation.introspection.table.DynamicTableModel;

public class IntroSpectionDialog
extends JDialog {
    private JTable table;
    private Window parent;

    public IntroSpectionDialog(Object introspected) {
        this(null, introspected);
    }

    public IntroSpectionDialog(Window parent, Object introspected) {
        this(parent, introspected.toString(), new ObjectJTable(new ObjectTableModel(introspected)));
    }

    public IntroSpectionDialog(Object introspected, String title) {
        this(null, title, new ObjectJTable(new ObjectTableModel(introspected)));
    }

    public IntroSpectionDialog(String title, IntrospectingTableModelInterface content) {
        this(null, title, content);
    }

    public IntroSpectionDialog(Window parent, String title, IntrospectingTableModelInterface content) {
        this(parent, title, new ObjectJTable(content));
    }

    public IntroSpectionDialog(Frame parent, Object introspected, String title) {
        this((Window)parent, title, new ObjectJTable(new ObjectTableModel(introspected)));
    }

    public IntroSpectionDialog(String title, JTable content) {
        this(null, title, content);
    }

    public IntroSpectionDialog(Window parent, String title, JTable content) {
        this.parent = parent;
        this.init(title, content);
    }

    private void init(String title, JTable table) {
        this.table = table;
        this.setModal(false);
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(table, 20, 30);
        this.getContentPane().add((Component)pane, "Center");
        if (table instanceof ObjectJTableInterface && ((ObjectJTableInterface)((Object)table)).getIntrospectingTableModel() instanceof DynamicTableModel) {
            DynamicTableModel model = (DynamicTableModel)((Object)((ObjectJTableInterface)((Object)table)).getIntrospectingTableModel());
            this.getContentPane().add((Component)new ButtonPanel(model, table), "South");
        }
        this.pack();
        this.setRelativeLocation();
        this.setVisible(true);
    }

    protected void formatDialog() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)this.table.getPreferredSize().height >= 0.5 * (double)d.height || (double)(this.table.getPreferredSize().height + this.getLocation().y) >= 0.9 * (double)d.height) {
            return;
        }
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        this.pack();
    }

    protected void setRelativeLocation() {
        this.setLocationRelativeTo(this.parent);
    }

    class ButtonPanel
    extends JPanel {
        private DynamicTableModel model;
        private JTable viewer;

        public ButtonPanel(DynamicTableModel model, JTable viewer) {
            this.model = model;
            this.viewer = viewer;
            this.setLayout(new BorderLayout());
            JPanel buttons = new JPanel();
            FlowLayout manager = new FlowLayout();
            manager.setHgap(0);
            manager.setVgap(0);
            buttons.setLayout(manager);
            this.add((Component)buttons, "Center");
            JButton addButton = new JButton("Add row");
            JButton delButton = new JButton("Delete rows");
            if (!model.isRowEditable()) {
                addButton.setEnabled(false);
                delButton.setEnabled(false);
            }
            buttons.add(addButton);
            buttons.add(delButton);
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.addRow();
                    IntroSpectionDialog.this.formatDialog();
                }
            });
            delButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.delRows();
                    IntroSpectionDialog.this.formatDialog();
                }
            });
        }

        protected void addRow() {
            this.model.createRow();
        }

        protected void delRows() {
            this.model.deleteRows(this.viewer.getSelectedRows());
        }
    }
}

