/*
 * @(#) DistCustom.java Dec 8, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.streams.StreamInterface;

/**
 * The custom distribution. This distribution is based on its entry map
 * consisting of value, probability pairs.
 * <p>
 * (c) copyright 2002-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">
 *         Alexander Verbraeck </a> <br>
 *         <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm"> Peter
 *         Jacobs </a>
 * @version 1.4 2004-03-22
 * @since 1.2
 */
public class DistCustom extends DistDiscrete
{
	/** the values */
	private Entry[] values = null;

	/**
	 * constructs a new DistCustom
	 * 
	 * @param stream the stream to use
	 * @param values the values for this custom distribution
	 */
	public DistCustom(final StreamInterface stream, final Entry[] values)
	{
		super(stream);
		this.values = values;
	}

	/**
	 * @see nl.tudelft.simulation.jstats.distributions.DistDiscrete#draw()
	 */
	public long draw()
	{
		if (this.values.length == 0)
		{
			throw new RuntimeException(
					"distribution not initialized! values==null");
		}
		double value = this.stream.nextDouble();
		double temp = 0.0;
		if (value < this.values[0].getProbability())
		{
			return this.values[0].getValue();
		}
		for (int i = 0; i < this.values.length - 1; i++)
		{
			temp = temp + this.values[i].getProbability();
			if (value >= temp
					&& value < temp + this.values[i + 1].getProbability())
			{
				return this.values[i].getValue();
			}
		}
		return this.values[this.values.length - 1].getValue();
	}

	/**
	 * @see nl.tudelft.simulation.jstats.distributions.DistDiscrete#probability(int)
	 */
	public double probability(final int observation)
	{
		for (int i = 0; i < this.values.length; i++)
		{
			if (observation == this.values[i].getValue())
			{
				return this.values[i].getProbability();
			}
		}
		return 0;
	}

	/**
	 * A Entry for the custom distribution
	 */
	public static class Entry
	{
		/** the value */
		private long value = 0L;

		/** the probability */
		private double probability = 0.0;

		/**
		 * constructs a new Entry
		 * 
		 * @param value the value
		 * @param probability the probability
		 */
		public Entry(final long value, final double probability)
		{
			this.value = value;
			this.probability = probability;
		}

		/**
		 * returns the value
		 * 
		 * @return long the value
		 */
		public long getValue()
		{
			return this.value;
		}

		/**
		 * returns the probability
		 * 
		 * @return double the probability
		 */
		public double getProbability()
		{
			return this.probability;
		}
	}
}