/*
 * @(#) Euler.java Apr 20, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;

/**
 * The Euler numerical estimator as described in <a
 * href="http://mathworld.wolfram.com/EulerForwardMethod.html">
 * http://mathworld.wolfram.com/EulerForwardMethod.html </a>
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Apr 20, 2004
 * @since 1.4
 */
public class Euler extends NumericalIntegrator
{
	/**
	 * constructs a new Euler
	 * 
	 * @param timeStep the timeStep
	 * @param equation the differentialEquation
	 */
	public Euler(final double timeStep,
			final DifferentialEquationInterface equation)
	{
		super(timeStep, equation);
	}

	/**
	 * @see nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator#next(double,
	 *      double[])
	 */
	public double[] next(final double x, final double[] y)
	{
		return super.add(y, super.multiply(this.timeStep, this.equation
				.dy(x, y)));
	}
}