/*
 * @(#) RungeKutta3.java Apr 20, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;

/**
 * The RungeKutta 3 numerical integrator.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Apr 20, 2004
 * @since 1.4
 */
public class RungeKutta3 extends NumericalIntegrator
{
	/**
	 * constructs a new RungeKutta3
	 * 
	 * @param timeStep the timeStep
	 * @param equation the differentialEquation
	 */
	public RungeKutta3(final double timeStep,
			final DifferentialEquationInterface equation)
	{
		super(timeStep, equation);
	}

	/**
	 * @see nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator
	 *      #next(double,double[])
	 */
	public double[] next(final double x, final double[] y)
	{
		double[] k1 = this.equation.dy(x, y);
		double[] k2 = this.equation.dy(x + 0.5 * this.timeStep, super.add(y,
				super.multiply(0.5 * this.timeStep, k1)));
		double[] k3 = this.equation.dy(x + 0.5 * this.timeStep, super.add(y,
				super.multiply(0.5 * this.timeStep, k2)));
		double[] sum = super.add(k1, super.multiply(4.0, k2), k3);
		return super.add(y, super.multiply(this.timeStep / 6.0, sum));
	}
}