/*
 * @(#) StatisticsObject.java Sep 21, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.jstats.statistics;

import java.awt.Container;
import java.rmi.RemoteException;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.jstats.Swingable;

/**
 * The StatisticsObject class defines a statistics object. This abstract class
 * is used to create general table representations for the Counter, the Tally
 * and the Persistent.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.7, 2004-03-18
 * @since 1.2
 */
public abstract class StatisticsObject extends EventProducer implements
		Swingable
{
	/**
	 * constructs a new StatisticsObject
	 */
	public StatisticsObject()
	{
		super();
	}

	/**
	 * represents the statistics object as Table.
	 * 
	 * @return TableModel the result
	 * @throws RemoteException on network failure
	 */
	public abstract TableModel getTable() throws RemoteException;

	/**
	 * represents this statisticsObject as Container.
	 * 
	 * @return Container the result
	 * @throws RemoteException on network failure
	 */
	public Container getSwingPanel() throws RemoteException
	{
		JTable table = new JTable(this.getTable());
		table.setEnabled(false);
		return new JScrollPane(table);
	}
}