/*
 * @(#)DistributionsGUIInspector.java Mar 21, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.jstats.distributions;

import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JTabbedPane;

import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.charts.histogram.Histogram;
import nl.tudelft.simulation.jstats.charts.histogram.HistogramSeries;
import nl.tudelft.simulation.jstats.streams.MersenneTwister;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

/**
 * The DistributionsGUIInspector provides graphical insight in the randomness of
 * different streams.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 * @version 1.0, 2004-03-18
 * @since 1.2
 */
public class DistributionsGUIInspector extends JTabbedPane
{
	/**
	 * constructs a new DistributionsGUIInspector
	 */
	public DistributionsGUIInspector()
	{
		this.setPreferredSize(new Dimension(500, 500));
		StreamInterface stream = new MersenneTwister();

		DistContinuous distribution = new DistUniform(stream, 0, 1.0);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 1}).getSwingPanel());

		distribution = new DistConstant(stream, 10.0);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 10}).getSwingPanel());


		distribution = new DistExponential(stream, 1.0);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 6}).getSwingPanel());

		distribution = new DistGamma(stream, 2.0, 1.0);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 9}).getSwingPanel());

		distribution = new DistWeibull(stream, 2.0, 1.0);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 4}).getSwingPanel());

		distribution = new DistNormal(stream, 0.0, 1.0);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{-3, 3}).getSwingPanel());

		distribution = new DistLogNormal(stream, 0.0, 1);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 5}).getSwingPanel());

		distribution = new DistBeta(stream, 1.5, 5);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 1}).getSwingPanel());

		distribution = new DistBeta(stream, 5, 1.5);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 1}).getSwingPanel());

		distribution = new DistPearson5(stream, 1, 1);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 5}).getSwingPanel());

		distribution = new DistPearson6(stream, 1, 2, 4);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 5}).getSwingPanel());

		distribution = new DistTriangular(stream, 1, 1.5, 7);
		this.add(distribution.toString(), this.createHistogram(distribution,
				new double[]{0, 7}).getSwingPanel());
	}

	/**
	 * creates a histogram of a discrete distribution
	 * 
	 * @param distribution the distribution to plot
	 * @param domain the domain to show on the histogram
	 * @return Histogram the histogram.
	 */
	private Histogram createHistogram(final Dist distribution,
			final double[] domain)
	{
		Histogram histogram = new Histogram(distribution.toString(), domain, 20);
		HistogramSeries series = new HistogramSeries(distribution.toString(),
				domain, null, 20);
		EventType accept = new EventType("DISTRIBUTION_VALUE");
		for (int i = 0; i < 10000; i++)
		{
			if (distribution instanceof DistContinuous)
			{
				Double value = new Double(((DistContinuous) distribution)
						.draw());
				series.notify(new Event(accept, this, value));
			} else
			{
				series.notify(new Event(accept, this, new Long(
						((DistDiscrete) distribution).draw())));
			}
		}
		histogram.getDataset().addSeries(series);
		return histogram;
	}

	/**
	 * executes the main program
	 * 
	 * @param args the commandline arguments
	 */
	public static void main(final String[] args)
	{
		JFrame app = new JFrame("Distributions gui tester");
		app.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		app.getContentPane().add(new DistributionsGUIInspector());
		app.pack();
		app.setVisible(true);
	}
}