/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.TimedEvent;
import nl.tudelft.simulation.logger.Logger;
import org.jfree.data.AbstractDataset;

public class XYSeries
extends AbstractDataset
implements EventListenerInterface {
    public static final EventType LOWER_RANGE_EVENT = new EventType("LOWER_RANGE_EVENT");
    public static final EventType UPPER_RANGE_EVENT = new EventType("UPPER_RANGE_EVENT");
    private String name = null;
    private List entries = new ArrayList();
    private short axisType = 0;

    public XYSeries(String name, short axisType) {
        this.axisType = axisType;
        this.name = name;
        this.fireDatasetChanged();
    }

    public synchronized void notify(EventInterface event) {
        TimedEvent timedEvent = (TimedEvent)event;
        if ((this.axisType == 2 || this.axisType == 3) && timedEvent.getTimeStamp() <= 0.0) {
            Logger.warning((Object)((Object)this), (String)"notify", (String)("refusing xvalue of " + event + " on logrithmic chart"));
            return;
        }
        if ((this.axisType == 1 || this.axisType == 3) && ((Number)timedEvent.getContent()).doubleValue() <= 0.0) {
            Logger.warning((Object)((Object)this), (String)"notify", (String)("refusing yValue of " + event + " on logrithmic chart"));
            return;
        }
        this.entries.add(new Tuple(timedEvent.getTimeStamp(), (Number)timedEvent.getContent()));
        this.fireDatasetChanged();
    }

    public int getItemCount() {
        return this.entries.size();
    }

    public Number getXValue(int item) {
        return ((Tuple)this.entries.get(item)).getXValue();
    }

    public Number getYValue(int item) {
        return ((Tuple)this.entries.get(item)).getYValue();
    }

    public String getSeriesName() {
        return this.name;
    }

    private class Tuple
    implements Serializable {
        private double xValue = Double.NaN;
        private double yValue = Double.NaN;

        public Tuple(double xValue, Number yValueNumber) {
            this.xValue = xValue;
            this.yValue = yValueNumber.doubleValue();
        }

        public Number getXValue() {
            return new Double(this.xValue);
        }

        public Number getYValue() {
            return new Double(this.yValue);
        }
    }
}

