/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistCustom
extends DistDiscrete {
    private Entry[] values = null;

    public DistCustom(StreamInterface stream, Entry[] values) {
        super(stream);
        this.values = values;
    }

    public long draw() {
        if (this.values.length == 0) {
            throw new RuntimeException("distribution not initialized! values==null");
        }
        double value = this.stream.nextDouble();
        double temp = 0.0;
        if (value < this.values[0].getProbability()) {
            return this.values[0].getValue();
        }
        for (int i = 0; i < this.values.length - 1; ++i) {
            if (!(value >= (temp += this.values[i].getProbability())) || !(value < temp + this.values[i + 1].getProbability())) continue;
            return this.values[i].getValue();
        }
        return this.values[this.values.length - 1].getValue();
    }

    public double probability(int observation) {
        for (int i = 0; i < this.values.length; ++i) {
            if ((long)observation != this.values[i].getValue()) continue;
            return this.values[i].getProbability();
        }
        return 0.0;
    }

    public static class Entry {
        private long value = 0L;
        private double probability = 0.0;

        public Entry(long value, double probability) {
            this.value = value;
            this.probability = probability;
        }

        public long getValue() {
            return this.value;
        }

        public double getProbability() {
            return this.probability;
        }
    }
}

