/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public class Gill
extends NumericalIntegrator {
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final double SQRT2D2 = 0.5 * Math.sqrt(2.0);

    public Gill(double timeStep, DifferentialEquationInterface equation) {
        super(timeStep, equation);
    }

    public double[] next(double x, double[] y) {
        double[] k1 = this.equation.dy(x, y);
        double[] k2 = this.equation.dy(x + 0.5 * this.timeStep, super.add(y, super.multiply(0.5, k1)));
        double[] k3 = this.equation.dy(x + 0.5 * this.timeStep, super.add(y, super.multiply(-0.5 + SQRT2D2, k1), super.multiply(1.0 - SQRT2D2, k2)));
        double[] k4 = this.equation.dy(x + this.timeStep, super.add(y, super.multiply(-SQRT2D2, k2), super.multiply(1.0 + SQRT2D2, k3)));
        double[] sum = super.add(k1, super.multiply(2.0 - SQRT2, k2), super.multiply(2.0 + SQRT2, k3), k4);
        return super.add(y, super.multiply(this.timeStep / 6.0, sum));
    }
}

