/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.Adams;
import nl.tudelft.simulation.jstats.ode.integrators.Euler;
import nl.tudelft.simulation.jstats.ode.integrators.Gill;
import nl.tudelft.simulation.jstats.ode.integrators.Heun;
import nl.tudelft.simulation.jstats.ode.integrators.Milne;
import nl.tudelft.simulation.jstats.ode.integrators.RungeKutta3;
import nl.tudelft.simulation.jstats.ode.integrators.RungeKutta4;
import nl.tudelft.simulation.jstats.ode.integrators.RungeKuttaCashCarp;
import nl.tudelft.simulation.jstats.ode.integrators.RungeKuttaFehlberg;

public abstract class NumericalIntegrator {
    public static final short EULER = 0;
    public static final short HEUN = 1;
    public static final short RUNGEKUTTA3 = 2;
    public static final short RUNGEKUTTA4 = 3;
    public static final short ADAMS = 4;
    public static final short GILL = 5;
    public static final short MILNE = 6;
    public static final short RUNGEKUTTAFEHLBERG = 7;
    public static final short RUNGEKUTTACASHCARP = 8;
    public static final short DEFAULT_INTEGRATOR = 3;
    protected double timeStep = Double.NaN;
    protected double[] error = null;
    protected DifferentialEquationInterface equation = null;

    public static NumericalIntegrator resolve(short integrationMethod, double timeStep, DifferentialEquationInterface equation) {
        switch (integrationMethod) {
            case 4: {
                return new Adams(timeStep, equation);
            }
            case 0: {
                return new Euler(timeStep, equation);
            }
            case 1: {
                return new Heun(timeStep, equation);
            }
            case 2: {
                return new RungeKutta3(timeStep, equation);
            }
            case 3: {
                return new RungeKutta4(timeStep, equation);
            }
            case 5: {
                return new Gill(timeStep, equation);
            }
            case 6: {
                return new Milne(timeStep, equation);
            }
            case 7: {
                return new RungeKuttaFehlberg(timeStep, equation);
            }
            case 8: {
                return new RungeKuttaCashCarp(timeStep, equation);
            }
        }
        throw new IllegalArgumentException("unknown integration method");
    }

    public NumericalIntegrator(double timeStep, DifferentialEquationInterface equation) {
        this.timeStep = timeStep;
        this.equation = equation;
    }

    public abstract double[] next(double var1, double[] var3);

    protected double[] multiply(double constant, double[] vector) {
        double[] prod = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            prod[i] = constant * vector[i];
        }
        return prod;
    }

    protected double[] add(double[] a, double[] b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i];
        }
        return sum;
    }

    protected double[] add(double[] a, double[] b, double[] c) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i] + c[i];
        }
        return sum;
    }

    protected double[] add(double[] a, double[] b, double[] c, double[] d) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i] + c[i] + d[i];
        }
        return sum;
    }

    protected double[] add(double[] a, double[] b, double[] c, double[] d, double[] e) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i] + c[i] + d[i] + e[i];
        }
        return sum;
    }

    protected double[] add(double[] a, double[] b, double[] c, double[] d, double[] e, double[] f) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i] + c[i] + d[i] + e[i] + f[i];
        }
        return sum;
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    public double[] getError() {
        return this.error;
    }
}

