/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.statistics;

import javax.swing.table.TableModel;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.statistics.StatisticsObject;
import nl.tudelft.simulation.jstats.statistics.StatisticsTableModel;

public class Counter
extends StatisticsObject
implements EventListenerInterface {
    public static final EventType COUNT_EVENT = new EventType("COUNT_EVENT");
    public static final EventType N_EVENT = new EventType("N_EVENT");
    protected long count = Long.MIN_VALUE;
    protected long n = Long.MIN_VALUE;
    protected String description;
    private Object semaphore = new Object();

    public Counter(String description) {
        this.description = description;
    }

    public long getCount() {
        return this.count;
    }

    public long getN() {
        return this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(EventInterface event) {
        if (!(event.getContent() instanceof Number)) {
            throw new IllegalArgumentException("event value !=Number.lang");
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.setCount(this.count + new Long(event.getContent().toString()));
            this.setN(this.n + 1L);
            if (!this.listeners.isEmpty()) {
                this.fireEvent(COUNT_EVENT, this.count);
                this.fireEvent(N_EVENT, this.n);
            }
        }
    }

    public String toString() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.semaphore;
        synchronized (object) {
            this.setN(0L);
            this.setCount(0L);
        }
    }

    public boolean isInitialized() {
        return this.n != Long.MIN_VALUE;
    }

    private void setCount(long count) {
        this.count = count;
        this.fireEvent((EventInterface)new Event(COUNT_EVENT, (Object)this, (Object)new Long(this.count)));
    }

    private void setN(long n) {
        this.n = n;
        this.fireEvent((EventInterface)new Event(N_EVENT, (Object)this, (Object)new Long(this.n)));
    }

    public String getDescription() {
        return this.description;
    }

    public TableModel getTable() {
        Object[] columnNames = new String[]{"field", "value"};
        EventType[] eventTypes = new EventType[]{null, N_EVENT, COUNT_EVENT};
        StatisticsTableModel result = new StatisticsTableModel(columnNames, eventTypes, 3);
        this.addListener(result, N_EVENT, false);
        this.addListener(result, COUNT_EVENT, false);
        result.setValueAt("name", 0, 0);
        result.setValueAt("n", 1, 0);
        result.setValueAt("count", 2, 0);
        result.setValueAt(this.description, 0, 1);
        result.setValueAt(new Long(this.n), 1, 1);
        result.setValueAt(new Long(this.count), 2, 1);
        return result;
    }
}

