/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.statistics;

import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.TimedEvent;
import nl.tudelft.simulation.jstats.statistics.Tally;
import nl.tudelft.simulation.logger.Logger;

public class Persistent
extends Tally {
    public static final EventType VALUE_EVENT = new EventType("VALUE_EVENT");
    private double startTime = Double.NaN;
    private double elapsedTime = Double.NaN;
    private double deltaTime = Double.NaN;
    private double lastValue = Double.NaN;

    public Persistent(String description) {
        super(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStdDev() {
        Object object = this.semaphore;
        synchronized (object) {
            if (this.n > 1L) {
                return Math.sqrt(this.varianceSum / (this.elapsedTime - this.deltaTime));
            }
            return Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSampleVariance() {
        Object object = this.semaphore;
        synchronized (object) {
            if (this.n > 1L) {
                return this.varianceSum / (this.elapsedTime - this.deltaTime);
            }
            return Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.semaphore;
        synchronized (object) {
            super.initialize();
            this.deltaTime = 0.0;
            this.elapsedTime = 0.0;
            this.lastValue = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(EventInterface event) {
        if (!(event instanceof TimedEvent) || !(event.getContent() instanceof Number)) {
            throw new IllegalArgumentException("event !=TimedEvent || event.source !=Double (" + event.getContent().getClass().toString() + ")");
        }
        TimedEvent timedEvent = (TimedEvent)event;
        double value = 0.0;
        if (event.getContent() instanceof Number) {
            value = ((Number)event.getContent()).doubleValue();
        } else {
            Logger.warning((Object)this, (String)"notify", (String)(event.getContent() + "should be a number."));
        }
        Object object = this.semaphore;
        synchronized (object) {
            super.fireEvent(VALUE_EVENT, this.lastValue, timedEvent.getTimeStamp());
            super.fireEvent(VALUE_EVENT, value, timedEvent.getTimeStamp());
            super.setN(this.n + 1L);
            if (value < this.min) {
                super.setMin(value);
            }
            if (value > this.max) {
                super.setMax(value);
            }
            super.setSum(this.sum + value);
            if (this.n == 1L) {
                super.setSampleMean(value);
                this.startTime = timedEvent.getTimeStamp();
            } else {
                this.deltaTime = timedEvent.getTimeStamp() - (this.elapsedTime + this.startTime);
                if (this.deltaTime > 0.0) {
                    double newAverage = (this.sampleMean * this.elapsedTime + this.lastValue * this.deltaTime) / (this.elapsedTime + this.deltaTime);
                    this.varianceSum += (this.lastValue - this.sampleMean) * (this.lastValue - newAverage) * this.deltaTime;
                    super.setSampleMean(newAverage);
                    this.elapsedTime += this.deltaTime;
                }
            }
            if (this.n > 1L) {
                super.fireEvent(Tally.STANDARD_DEVIATION_EVENT, this.getStdDev());
                this.fireEvent(Tally.SAMPLE_VARIANCE_EVENT, this.getSampleVariance());
            }
            this.lastValue = value;
        }
    }
}

