/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.statistics;

import javax.swing.table.TableModel;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.distributions.DistNormal;
import nl.tudelft.simulation.jstats.statistics.StatisticsObject;
import nl.tudelft.simulation.jstats.statistics.StatisticsTableModel;
import nl.tudelft.simulation.jstats.streams.MersenneTwister;

public class Tally
extends StatisticsObject
implements EventListenerInterface {
    public static final EventType SAMPLE_MEAN_EVENT = new EventType("SAMPLE_MEAN_EVENT");
    public static final EventType SAMPLE_VARIANCE_EVENT = new EventType("SAMPLE_VARIANCE_EVENT");
    public static final EventType MIN_EVENT = new EventType("MIN_EVENT");
    public static final EventType MAX_EVENT = new EventType("MAX_EVENT");
    public static final EventType N_EVENT = new EventType("N_EVENT");
    public static final EventType STANDARD_DEVIATION_EVENT = new EventType("STANDARD_DEVIATION_EVENT");
    public static final EventType SUM_EVENT = new EventType("SUM_EVENT");
    public static final short LEFT_SIDE_CONFIDENCE = -1;
    public static final short BOTH_SIDE_CONFIDENCE = 0;
    public static final short RIGTH_SIDE_CONFIDENCE = 1;
    protected double sum = Double.NaN;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected double sampleMean = Double.NaN;
    protected double varianceSum = Double.NaN;
    protected long n = Long.MIN_VALUE;
    protected String description;
    private DistNormal confidenceDistribution = new DistNormal(new MersenneTwister());
    protected Object semaphore = new Object();

    public Tally(String description) {
        this.description = description;
    }

    public double getSampleMean() {
        return this.sampleMean;
    }

    public double[] getConfidenceInterval(double alpha) {
        return this.getConfidenceInterval(alpha, (short)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getConfidenceInterval(double alpha, short side) {
        if (side != -1 && side != 0 && side != 1) {
            throw new IllegalArgumentException("side of confidence level is not defined");
        }
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("1 >= confidenceLevel >= 0");
        }
        Object object = this.semaphore;
        synchronized (object) {
            if (new Double(this.sampleMean).isNaN() || new Double(this.getStdDev()).isNaN()) {
                return null;
            }
            double level = 1.0 - alpha;
            if (side == 0) {
                level = 1.0 - alpha / 2.0;
            }
            double z = this.confidenceDistribution.getInverseCumulativeProbability(level);
            double confidence = z * Math.sqrt(this.getSampleVariance() / (double)this.n);
            double[] result = new double[]{this.sampleMean - confidence, this.sampleMean + confidence};
            if (side == -1) {
                result[1] = this.sampleMean;
            }
            if (side == 1) {
                result[0] = this.sampleMean;
            }
            result[0] = Math.max(result[0], this.min);
            result[1] = Math.min(result[1], this.max);
            return result;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public long getN() {
        return this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStdDev() {
        Object object = this.semaphore;
        synchronized (object) {
            if (this.n > 1L) {
                return Math.sqrt(this.varianceSum / (double)(this.n - 1L));
            }
            return Double.NaN;
        }
    }

    public double getSum() {
        return this.sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSampleVariance() {
        Object object = this.semaphore;
        synchronized (object) {
            if (this.n > 1L) {
                return this.varianceSum / (double)(this.n - 1L);
            }
            return Double.NaN;
        }
    }

    public TableModel getTable() {
        Object[] columnNames = new String[]{"field", "value"};
        EventType[] eventTypes = new EventType[]{null, N_EVENT, MIN_EVENT, MAX_EVENT, SAMPLE_MEAN_EVENT, SAMPLE_VARIANCE_EVENT, STANDARD_DEVIATION_EVENT, SUM_EVENT};
        StatisticsTableModel result = new StatisticsTableModel(columnNames, eventTypes, 8);
        this.addListener(result, N_EVENT, false);
        this.addListener(result, MAX_EVENT, false);
        this.addListener(result, MIN_EVENT, false);
        this.addListener(result, SAMPLE_MEAN_EVENT, false);
        this.addListener(result, SAMPLE_VARIANCE_EVENT, false);
        this.addListener(result, STANDARD_DEVIATION_EVENT, false);
        this.addListener(result, SUM_EVENT, false);
        result.setValueAt("name", 0, 0);
        result.setValueAt("n", 1, 0);
        result.setValueAt("min", 2, 0);
        result.setValueAt("max", 3, 0);
        result.setValueAt("sample-mean", 4, 0);
        result.setValueAt("sample-variance", 5, 0);
        result.setValueAt("st. dev.", 6, 0);
        result.setValueAt("sum", 7, 0);
        result.setValueAt(this.description, 0, 1);
        result.setValueAt(new Long(this.n), 1, 1);
        result.setValueAt(new Double(this.min), 2, 1);
        result.setValueAt(new Double(this.max), 3, 1);
        result.setValueAt(new Double(this.sampleMean), 4, 1);
        result.setValueAt(new Double(this.getSampleVariance()), 5, 1);
        result.setValueAt(new Double(this.getStdDev()), 6, 1);
        result.setValueAt(new Double(this.getSum()), 7, 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.semaphore;
        synchronized (object) {
            this.setMax(-1.7976931348623157E308);
            this.setMin(Double.MAX_VALUE);
            this.setN(0L);
            this.setSum(0.0);
            this.varianceSum = 0.0;
        }
    }

    public boolean isInitialized() {
        return !Double.isNaN(this.max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(EventInterface event) {
        if (!(event.getContent() instanceof Number)) {
            throw new IllegalArgumentException("Tally does not accept " + event);
        }
        double value = ((Number)event.getContent()).doubleValue();
        Object object = this.semaphore;
        synchronized (object) {
            if (new Double(this.sampleMean).isNaN()) {
                this.sampleMean = 0.0;
            }
            double newsampleMean = this.sampleMean + (value - this.sampleMean) / (double)(this.n + 1L);
            this.varianceSum += (value - this.sampleMean) * (value - newsampleMean);
            this.setSampleMean(newsampleMean);
            this.setSum(this.sum + value);
            this.setN(this.n + 1L);
            if (value < this.min) {
                this.setMin(value);
            }
            if (value > this.max) {
                this.setMax(value);
            }
            if (this.n > 1L) {
                this.fireEvent(STANDARD_DEVIATION_EVENT, this.getStdDev());
                this.fireEvent(SAMPLE_VARIANCE_EVENT, this.getSampleVariance());
            }
        }
    }

    public String toString() {
        return this.description;
    }

    protected double setSampleMean(double sampleMean) {
        this.sampleMean = sampleMean;
        this.fireEvent(SAMPLE_MEAN_EVENT, sampleMean);
        return this.sampleMean;
    }

    protected double setMin(double min) {
        this.min = min;
        this.fireEvent(MIN_EVENT, min);
        return this.min;
    }

    protected double setMax(double max) {
        this.max = max;
        this.fireEvent(MAX_EVENT, max);
        return this.max;
    }

    protected long setN(long n) {
        this.n = n;
        this.fireEvent(N_EVENT, n);
        return this.n;
    }

    protected double setSum(double sum) {
        this.sum = sum;
        this.fireEvent(SUM_EVENT, sum);
        return this.sum;
    }
}

