/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.streams;

import nl.tudelft.simulation.jstats.streams.RandomNumberGenerator;

public class DX120Generator
extends RandomNumberGenerator {
    private static final int K = 120;
    private static final int MASK = Integer.MAX_VALUE;
    private static final int MULTIPLIER = 16807;
    private int[] buffer = null;
    private int index;
    private int k13;
    private int k23;

    public DX120Generator() {
        this(System.currentTimeMillis());
    }

    public DX120Generator(long seed) {
        super(seed);
        this.initialize();
    }

    private void initialize() {
        this.buffer = new int[120];
        this.buffer[0] = (int)this.seed & Integer.MAX_VALUE;
        if (this.buffer[0] == 0) {
            this.setSeed(System.currentTimeMillis());
        }
        if (this.buffer[0] < 0) {
            this.buffer[0] = Math.abs(this.buffer[0] - 1);
        }
        for (int i = 1; i < 120; ++i) {
            this.buffer[i] = 16807 * this.buffer[i - 1] & Integer.MAX_VALUE;
        }
        this.index = 119;
        this.k13 = 79;
        this.k23 = 39;
    }

    protected synchronized long next(int bits) {
        if (bits < 0 || bits > 64) {
            throw new IllegalArgumentException("bits (" + bits + ") not in range [0,64]");
        }
        int tempIndex = this.index++;
        if (this.index >= 120) {
            this.index = 0;
        }
        if (++this.k13 >= 120) {
            this.k13 = 0;
        }
        if (++this.k23 >= 120) {
            this.k23 = 0;
        }
        this.buffer[this.index] = 521673 * (this.buffer[this.index] + this.buffer[this.k13] + this.buffer[this.k23] + this.buffer[tempIndex]) & Integer.MAX_VALUE;
        if (bits <= 32) {
            return this.buffer[this.index] >>> 32 - bits;
        }
        return this.buffer[this.index] << (int)(32L + this.next(bits - 32));
    }

    public synchronized void setSeed(long seed) {
        this.seed = seed;
        this.initialize();
    }
}

