/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.streams;

import nl.tudelft.simulation.jstats.streams.StreamInterface;

public abstract class RandomNumberGenerator
implements StreamInterface {
    protected long seed = -1L;

    public RandomNumberGenerator() {
        this(System.currentTimeMillis());
    }

    public RandomNumberGenerator(long seed) {
        if (seed <= 0L) {
            throw new IllegalArgumentException("seed(" + seed + ")<=0");
        }
        this.setSeed(seed);
    }

    public void reset() {
        this.setSeed(this.seed);
    }

    protected abstract long next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0L;
    }

    public double nextDouble() {
        long l = (this.next(26) << 27) + this.next(27);
        return (double)l / 9.007199254740992E15;
    }

    public float nextFloat() {
        int i = (int)this.next(24);
        return (float)i / 1.6777216E7f;
    }

    public int nextInt() {
        return (int)this.next(32);
    }

    public synchronized int nextInt(int i, int j) {
        int val;
        int bits;
        if (i < 0 || j <= 0 || i >= j) {
            throw new IllegalArgumentException("i, j must be positive");
        }
        int n = j - i;
        if ((n & -n) == n) {
            return (int)((long)i + (long)n * this.next(31) >> 31);
        }
        while ((bits = (int)this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return i + val;
    }

    public long nextLong() {
        return (this.next(32) << 32) + this.next(32);
    }

    public abstract void setSeed(long var1);

    public long getSeed() {
        return this.seed;
    }

    public String toString() {
        return this.getClass().toString() + "[" + this.seed + "]";
    }
}

