/*
 * @(#) SimulatorRunThread.java Oct 15, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.concurrent;

import java.util.logging.Logger;

/**
 * The WorkerThread is a working thread. The thread sleeps while not
 * interrupted. If interuppted the jon.run operation is invoked.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 2.0 21.09.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>, <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public class WorkerThread extends Thread
{
	/** the job to execute */
	private Runnable job = null;

	/** finalized */
	private boolean finalized = false;

	/**
	 * constructs a new SimulatorRunThread
	 * 
	 * @param name the name of the thread
	 * @param job the job to run
	 */
	public WorkerThread(final String name, final Runnable job)
	{
		super(name);
		this.job = job;
		this.setDaemon(false);
		this.setPriority(Thread.NORM_PRIORITY);
		this.start();
	}

	/**
	 * @see java.lang.Object#finalize()
	 */
	public synchronized void finalize()
	{
		this.finalized = true;
		try
		{
			super.finalize();
		} catch (Throwable exception)
		{
			Logger.getLogger("nl.tudelft.simulation.language.concurrent")
					.warning(exception.getMessage());
		}
	}

	/**
	 * @see java.lang.Runnable#run()
	 */
	public synchronized void run()
	{
		while (!this.finalized) //always until finalized
		{
			try
			{
				this.wait(); //as long as possible
			} catch (InterruptedException interruptedException)
			{
				this.interrupt(); //set the status to interrupted
				try
				{
					this.job.run();
				} catch (Exception exception)
				{
					Logger.getLogger(
							"nl.tudelft.simulation.language.concurrent")
							.severe(exception.getMessage());
				}
				Thread.interrupted();
			}
		}
	}
}