/*
 * @(#) BoundingBox.java Jun 17, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.d3;

import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;

/**
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Jun 17, 2004
 * @since 1.4
 */
public class BoundingBox extends javax.media.j3d.BoundingBox
{
	/**
	 * constructs a new BoundingBox
	 */
	public BoundingBox()
	{
		super();
	}

	/**
	 * constructs a new BoundingBox around [0;0;0]
	 * 
	 * @param deltaX the deltaX
	 * @param deltaY the deltaY
	 * @param deltaZ the deltaZ
	 */
	public BoundingBox(final double deltaX, final double deltaY,
			final double deltaZ)
	{
		super(new Point3d(-0.5 * deltaX, -0.5 * deltaY, -0.5 * deltaZ),
				new Point3d(0.5 * deltaX, 0.5 * deltaY, 0.5 * deltaZ));
		this.normalize();
	}

	/**
	 * constructs a new BoundingBox
	 * 
	 * @param arg0 the boundaries
	 */
	public BoundingBox(final Bounds arg0)
	{
		super(arg0);
		this.normalize();
	}

	/**
	 * constructs a new BoundingBox
	 * 
	 * @param arg0 the boundaries
	 */
	public BoundingBox(final Bounds[] arg0)
	{
		super(arg0);
		this.normalize();
	}

	/**
	 * constructs a new BoundingBox
	 * 
	 * @param arg0 the boundaries
	 * @param arg1 the point
	 */
	public BoundingBox(final Point3d arg0, final Point3d arg1)
	{
		super(arg0, arg1);
		this.normalize();
	}

	/**
	 * normalizes the boundingBox
	 */
	public void normalize()
	{
		Point3d p1 = new Point3d();
		Point3d p2 = new Point3d();
		this.getLower(p1);
		this.getUpper(p2);
		this.setLower(new Point3d(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y),
				Math.min(p1.z, p2.z)));
		this.setUpper(new Point3d(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y),
				Math.max(p1.z, p2.z)));
	}
}