/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.reflection;

import java.io.Serializable;
import java.lang.reflect.Array;
import nl.tudelft.simulation.language.primitives.Primitive;

public class FieldSignature
implements Serializable {
    private String value;

    public FieldSignature(String value) {
        this.value = value;
    }

    public FieldSignature(Class clazz) {
        this(FieldSignature.toDescriptor(clazz));
    }

    public String getStringValue() {
        return this.value;
    }

    public Class getClassValue() throws ClassNotFoundException {
        return FieldSignature.toClass(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static final String toDescriptor(Class[] classes) {
        String result = "";
        for (int i = 0; i < classes.length; ++i) {
            result = result + FieldSignature.toDescriptor(classes[i]);
        }
        return result;
    }

    public static final String toDescriptor(Class clazz) {
        if (clazz.getName().startsWith("[")) {
            return clazz.getName().replace('.', '/');
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Integer.TYPE)) {
                return "I";
            }
            if (clazz.equals(Double.TYPE)) {
                return "D";
            }
            if (clazz.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (clazz.equals(Character.TYPE)) {
                return "C";
            }
            if (clazz.equals(Byte.TYPE)) {
                return "B";
            }
            if (clazz.equals(Float.TYPE)) {
                return "F";
            }
            if (clazz.equals(Long.TYPE)) {
                return "J";
            }
            if (clazz.equals(Short.TYPE)) {
                return "S";
            }
            return "V";
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static final Class toClass(String descriptor) throws ClassNotFoundException {
        String className = descriptor;
        Class<?> result = null;
        int array = 0;
        while (className.charAt(array) == '[') {
            ++array;
        }
        if ((className = className.substring(array)).startsWith("L")) {
            className = className.replaceAll("/", ".");
            className = className.substring(1, className.length() - 1);
            try {
                result = Class.forName(className);
            }
            catch (Exception exception) {
                result = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
        } else {
            result = Primitive.forName(className);
        }
        if (result == null && !descriptor.startsWith("[")) {
            return FieldSignature.toClass("L" + descriptor + ";");
        }
        if (array == 0) {
            return result;
        }
        try {
            int[] dimensions = new int[array];
            result = Array.newInstance(result, dimensions).getClass();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(result + " class not found");
        }
        return result;
    }
}

